/*
   orxonox - the future of 3D-vertical-scrollers

   Copyright (C) 2004 orx

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   ### File Specific:
   main-programmer: Patrick Boenzli
   co-programmer: Christian Meyer
*/

#define DEBUG_SPECIAL_MODULE DEBUG_MODULE_WORLD_ENTITY


#include "executor/executor.h"
#include "player.h"

#include "track_manager.h"
#include "objModel.h"
#include "resource_manager.h"
#include "factory.h"

#include "weapons/weapon_manager.h"
#include "weapons/test_gun.h"
#include "weapons/turret.h"
#include "weapons/cannon.h"

#include "list.h"

#include "event_handler.h"

#include "event.h"

using namespace std;

CREATE_FACTORY(Player, CL_PLAYER);

/**
 * creates a new Player
 * @param isFree if the player is free
*/
Player::Player()
{
  this->init();
}


/**
 *  destructs the player, deletes alocated memory
 */
Player::~Player ()
{
}

//#include "glgui_pushbutton.h"

/**
 * initializes a Player
 */
void Player::init()
{
//  this->setRelDir(Quaternion(M_PI, Vector(1,0,0)));
  this->setClassID(CL_PLAYER, "Player");

  PRINTF(4)("PLAYER INIT\n");

}


void Player::process(const Event &event)
{
  this->controllable->process(event);
}

