/*
   orxonox - the future of 3D-vertical-scrollers

   Copyright (C) 2004 orx

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   ### File Specific:
   main-programmer: Benjamin Grauer
   co-programmer: ...
*/

/*!
 * @file debug.h
  *  Handles output to console for different Verbose-Modes.

    There are two main modes HARD and SOFT. HARD is precessed during compileTime where SOFT is for runtime.
    \li HARD: One can choose between different modes. see: // DEFINE_MODULES
    \li SOFT: If you want each module can have its own variable for processing. just pass it to DEBUG_MODULE_SOFT
*/

#ifndef _DEBUG_H
#define _DEBUG_H

#include "confincl.h"
#include "shell_buffer.h"

#include <stdio.h>

// DEFINE ERROR MODES
#define NO              0
#define ERR             1
#define WARN            2
#define INFO            3
//#define DEBUG           4
#define vDEBUG          5

extern int verbose;

//definitions
#ifndef MODULAR_DEBUG
 #define HARD_DEBUG_LEVEL DEBUG
 #define SOFT_DEBUG_LEVEL verbose
#else /* MODULAR_DEBUG */
 #ifndef DEBUG_MODULE_SOFT
  #define SOFT_DEBUG_LEVEL verbose
 #else /* DEBUG_MODULE_SOFT */
  #define SOFT_DEBUG_LEVEL DEBUG_MODULE_SOFT
 #endif /* DEBUG_MODULE_SOFT */

 #ifndef DEBUG_SPECIAL_MODULE
  #define HARD_DEBUG_LEVEL DEBUG
 #else /* DEBUG_SPECIAL_MODULE */
  ////////////////////
  // DEFINE MODULES //
  ////////////////////
  // FRAMEWORK
  #define DEBUG_MODULE_BASE                  2
  #define DEBUG_MODULE_ORXONOX               2
  #define DEBUG_MODULE_WORLD                 2
  #define DEBUG_MODULE_NETWORK               2

  // LOADING
  #define DEBUG_MODULE_LOAD                  2
  #define DEBUG_MODULE_IMPORTER              2

  // ENGINES
  #define DEBUG_MODULE_GRAPHICS              2
  #define DEBUG_MODULE_EVENT                 2
  #define DEBUG_MODULE_PHYSICS               2
  #define DEBUG_MODULE_GARBAGE_COLLECTOR     2
  #define DEBUG_MODULE_OBJECT_MANAGER        2
  #define DEBUG_MODULE_ANIM                  2
  #define DEBUG_MODULE_COLLISON_DETECTION    2
  #define DEBUG_MODULE_SPATIAL_SEPARATION    2
  #define DEBUG_MODULE_GUI                   2

  // MISC
  #define DEBUG_MODULE_TRACK_MANAGER         2
  #define DEBUG_MODULE_MATH                  2

  #define DEBUG_MODULE_PNODE                 2
  #define DEBUG_MODULE_WORLD_ENTITY          2

  #define DEBUG_MODULE_WEAPON                2

  #define HARD_DEBUG_LEVEL DEBUG_SPECIAL_MODULE

 #endif /* DEBUG_SPECIAL_MODULE */
#endif /* MODULAR_DEBUG */

///////////////////////////////////////////////////
/// PRINTF: prints with filename and linenumber ///
///////////////////////////////////////////////////
#define PRINTFNO      PRINTF0
#define PRINTFERR     PRINTF1
#define PRINTFWARN    PRINTF2
#define PRINTFINFO    PRINTF3
#define PRINTFDEBUG   PRINTF4
#define PRINTFVDEBUG  PRINTF5

#if DEBUG <= 3
#define PRINTF(x)        PRINT(x)
#endif
#ifndef NO_SHELL
#define PRINT_EXEC       printf //ShellBuffer::addBufferLineStatic
#else /* NO_SHELL */
#define PRINT_EXEC       printf
#endif

#ifndef PRINTF
#ifdef DEBUG

#define PRINTF(x) \
           PRINTF ## x

#if HARD_DEBUG_LEVEL >= ERR
#define PRINTF1 \
    if (SOFT_DEBUG_LEVEL >= ERR) \
      printf("(EE)::%s:%d:", __FILE__, __LINE__) && PRINT_EXEC
#else
#define PRINTF1 if (NO)
#endif

#if HARD_DEBUG_LEVEL >= WARN
#define PRINTF2 \
     if (SOFT_DEBUG_LEVEL >= WARN) \
       printf("(WW)::%s:%d:", __FILE__, __LINE__) && PRINT_EXEC

#else
#define PRINTF2 if (NO)
#endif

#if HARD_DEBUG_LEVEL >= INFO
#define PRINTF3 \
     if (SOFT_DEBUG_LEVEL >= INFO) \
       printf("(II)::%s:%d:", __FILE__, __LINE__) && PRINT_EXEC
#else
#define PRINTF3 if (NO)
#endif

#if HARD_DEBUG_LEVEL >= DEBUG
#define PRINTF4 \
     if (SOFT_DEBUG_LEVEL >= DEBUG) \
       printf("(DD)::%s:%d:", __FILE__, __LINE__) && PRINT_EXEC
#else
#define PRINTF4 if (NO)
#endif

#if HARD_DEBUG_LEVEL >= vDEBUG
#define PRINTF5 \
     if (SOFT_DEBUG_LEVEL >= vDEBUG) \
       printf("(VD)::%s:%d:", __FILE__, __LINE__) && PRINT_EXEC
#else
#define PRINTF5 if (NO)
#endif

#else
#define PRINTF(x) if (NO)
#endif

#define PRINTF0 \
    printf("%s:%d::", __FILE__, __LINE__) && PRINT_EXEC
#endif

///////////////////////////////////////////////////
///  PRINT: just prints output as is            ///
///////////////////////////////////////////////////
#define PRINTNO      PRINT0
#define PRINTERR     PRINT1
#define PRINTWARN    PRINT2
#define PRINTINFO    PRINT3
#define PRINTDEBUG   PRINT4
#define PRINTVDEBUG  PRINT5

#ifdef  DEBUG
#define PRINT(x) \
  PRINT ## x

#if HARD_DEBUG_LEVEL >= ERR
#define PRINT1  \
  if (SOFT_DEBUG_LEVEL >= ERR)  \
    PRINT_EXEC
#else
#define PRINT1 if (NO)
#endif

#if HARD_DEBUG_LEVEL >= WARN
#define PRINT2 \
  if (SOFT_DEBUG_LEVEL >= WARN) \
    PRINT_EXEC

#else
#define PRINT2 if (NO)
#endif

#if HARD_DEBUG_LEVEL >= INFO
#define PRINT3 \
  if (SOFT_DEBUG_LEVEL >= INFO) \
    PRINT_EXEC
#else
#define PRINT3 if (NO)
#endif

#if HARD_DEBUG_LEVEL >= DEBUG
#define PRINT4 \
  if (SOFT_DEBUG_LEVEL >= DEBUG) \
    PRINT_EXEC
#else
#define PRINT4 if (NO)
#endif

#if HARD_DEBUG_LEVEL >= vDEBUG
#define PRINT5 \
     if (SOFT_DEBUG_LEVEL >= vDEBUG) \
       PRINT_EXEC
#else
#define PRINT5 if (NO)
#endif


#else
#define PRINT(x) if (NO)
#endif

#define PRINT0 \
  PRINT_EXEC

#endif /* _DEBUG_H */
