/*!
 * @file bomb.h
 * @brief description
*/

#ifndef _BOMB_H
#define _BOMB_H

#include "projectile.h"
class FastFactory;
class ParticleSystem;
class ParticleEmitter;

//! A Class to ...
class Bomb : public Projectile
{

 public:
  Bomb(const TiXmlElement* root = NULL);
  virtual ~Bomb();

  void loadParams(const TiXmlElement* root);
  void init();

//  virtual void postSpawn ();
//  virtual void leftWorld ();


  virtual void draw() const;
  virtual void tick(float time);
  virtual void collidesWith (WorldEntity* entity, const Vector& location);
  virtual void activate();
  virtual void deactivate();

  void detonate(float size);

 private:
  static FastFactory*               fastFactory;
  static ParticleSystem*            trailParticles;
  static ParticleSystem*            explosionParticles;

  ParticleEmitter*                  emitter;

};

#endif /* BOMB */
