/*
   orxonox - the future of 3D-vertical-scrollers

   Copyright (C) 2004 orx

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   ### File Specific:
   main-programmer: ...
   co-programmer: ...
*/

//#define DEBUG_SPECIAL_MODULE DEBUG_MODULE_WORLD_ENTITY

#include "object_manager.h"
#include "class_list.h"

#include "p_node.h"
#include "world_entity.h"
#include "list.h"

using namespace std;


/**
 * standard constructor
 */
ObjectManager::ObjectManager ()
{
   this->setClassID(CL_OBJECT_MANAGER, "ObjectManager");
   this->setName("ObjectManager");

   pNodeList = NULL;
}

/**
 *  the singleton reference to this class
 */
ObjectManager* ObjectManager::singletonRef = NULL;

/**
   @brief standard deconstructor
 */
ObjectManager::~ObjectManager ()
{
  ObjectManager::singletonRef = NULL;
}

/**
 * returns a new List with a list of WorldEntities of distance Radius from center
 */
std::list<WorldEntity*>* ObjectManager::distanceFromObject(const PNode& center, float radius, ClassID classID)
{
  const std::list<BaseObject*>* objectList = ClassList::getList(classID);
  if (objectList != NULL)
  {
    std::list<WorldEntity*>* newList = new std::list<WorldEntity*>;

    list<BaseObject*>::const_iterator node;
    for (node = objectList->begin(); node != objectList->end(); node++)
    {
      if ((dynamic_cast<PNode*>(*node)->getAbsCoor() - center.getAbsCoor()).len() < radius)
        newList->push_back(dynamic_cast<WorldEntity*>(*node));
    }
    return newList;
  }
  return NULL;
}
