/*!
 * @file simple_sync.h
 *  implementation of a network sync test
 */

#ifndef _SIMPLE_SYNC
#define _SIMPLE_SYNC

#include "synchronizeable.h"


class SimpleSync : public Synchronizeable
  {
  public:
    SimpleSync(const char* name);
    ~SimpleSync();

    virtual void writeBytes(const byte* data, int length);
    virtual int readBytes(byte* data) const;


  private:
    virtual void writeDebug() const;
    virtual void readDebug() const;


  private:
    byte* inData;
    int   inLength;
    int   recLength;
    byte* outData;
    int   outLength;
  };

#endif /* _SIMPLE_SYNC */
