
#include "stdlibincl.h"
#include <stdarg.h>
#include <stdio.h>
#include "shell_buffer.h"
#include "class_list.h"

#include "network_manager.h"
#include "network_socket.h"
#include "network_stream.h"
#include "synchronizeable.h"

#include "simple_sync.h"

int verbose = 4;


/* outputs the help */
int startHelp(int argc, char** argv)
{
  printf("Network is a network unit test\n");
  printf(" --help                     this output\n");
  printf(" -st,  --sockettest         test network_socket\n");
  printf(" -ft,  --frameworktest      test the network module\n");
  printf(" --server [port number]     creates a test server\n");
  printf(" --client [address] [port]  connects to a server\n");
  printf("\n");
}


/* test SDL network socket */
int testSocket(int argc, char** argv)
{
  IPaddress ip;
  SDLNet_ResolveHost(&ip, "127.0.0.1", 9999);
  NetworkSocket server;
  server.listen(9999);
  SDL_Delay(20);

  NetworkSocket client(ip);

  char buf[1024];

  printf("read from client before sending data\n");
  printf("result: %d bytes\n", client.readBytes((byte*)buf, 1024));

  printf("read from server before sending data\n");
  printf("result: %d bytes\n", server.readBytes((byte*)buf, 1024));

  int n;
  char * str1 = "client to server";
  char * str2 = "server to client";
  n = client.writeBytes((byte*)str1, strlen(str1)+1);
  printf("%d bytes send from client\n", n);
  n = server.writeBytes((byte*)str2, strlen(str2)+1);
  printf("%d bytes send from server\n", n);
  SDL_Delay(1000);

  printf("read from server\n");
  n = server.readBytes((byte*)buf, 1024);
  printf("read %d bytes\n", n);
  if (n<0)
    return -1;

  printf("data: %s\n", buf);
  printf("read from client\n");
  n = client.readBytes((byte*)buf, 1024);

  printf("read %d bytes\n", n);
  if (n<0)
    return -1;

  printf("data: %s\n", buf);

  printf("testing a bigger amount of data\n");

#define _N_ELEMENTS 212994
  char sendbuf[_N_ELEMENTS+1];
  char recvbuf[_N_ELEMENTS+1];
  sendbuf[_N_ELEMENTS] = '\0';
  recvbuf[_N_ELEMENTS] = '\0';

  for (int i = 0; i<_N_ELEMENTS; i++)
    sendbuf[i] = i%26 + 65;

  printf("write\n");
  printf("result = %d\n", client.writeBytes((byte*)sendbuf, _N_ELEMENTS));

  SDL_Delay(50);

  printf("read\n");
  int nbytes = server.readBytes((byte*)recvbuf, _N_ELEMENTS);
  int offset = nbytes;

  while (nbytes>0)
  {
    SDL_Delay(10);
    //printf("read\n");
    nbytes = server.readBytes((byte*)recvbuf+offset, _N_ELEMENTS-offset);
    offset += nbytes;
    //printf("nbytes=%d, offset=%d\n", nbytes, offset);
  }

  printf("strcmp = %d (0 is good :D not 0 is evil)\noffset = %d\n", strncmp(sendbuf, recvbuf, _N_ELEMENTS), offset);

  //printf("%s\n%s\n", sendbuf, recvbuf);

  for (int i = 0; i<_N_ELEMENTS; i++)
  {
    if (sendbuf[i]!=recvbuf[i])
    {
      printf("byte %d is the first difference\n", i+1);
      break;
    }
  }

  return 0;
}


int testFramework(int argc, char** argv)
{
  printf("=================\n");
  printf("TestFramework\n");
  printf("=================\n");

  Synchronizeable* clientSync = new SimpleSync("Client\0");
  Synchronizeable* serverSync = new SimpleSync("Server\0");

  unsigned int port = 9999;

  /* create the network manager */
  NetworkManager* nm = new NetworkManager();

  /* initialize the network manager */
  nm->initialize();

  /* create a server stream */
  nm->createServer(*serverSync, port);

  /* esatblish a connection */
  IPaddress ip;
  int error = SDLNet_ResolveHost(&ip, "127.0.0.1", port);
  //SDLNet_ResolveHost(&ip, "localhost", port);
  if(error == -1) printf("\n\nerror on address resolution, program inconsistancy\n\n");
  nm->establishConnection(ip, *clientSync);
  /* adding some break for connection setup */
  SDL_Delay(20);

  /* synchronize the data 1 time (increment for longer tests) */
  for( int i = 0; i < 3; i++) {
    nm->synchronize();
    /* simulate the network delay */
    SDL_Delay(50);
  }

  printf("Test finished\n");


  /* delete the network manager again */
  delete nm;

  delete clientSync;
  delete serverSync;

  return 0;
}



/**
 *
 * @param argc
 * @param argv
 * @return
 */
int startServer(int argc, char** argv)
{
  if( argc <= 2) {
    printf(" Wrong arguments try following notations:\n");
    printf("   --server [port number]\n");
    return 0;
  }

  int port = atoi(argv[2]);
  printf("Starting Server on port %i\n", port);

  NetworkManager* netMan = new NetworkManager();
  Synchronizeable* ss = new SimpleSync("Server\0");

  //NetworkStream* server = new NetworkStream(port, ss, NET_SERVER);
  netMan->createServer(*ss, port);
  SDL_Delay(20);

  for(;;) {
    netMan->synchronize();
    SDL_Delay(500);
  }
  return 0;
}


int startClient(int argc, char** argv)
{
  if( argc < 3) {
    printf(" Wrong arguments try following notations:\n");
    printf("   --client [server ip] [port number]\n");
    printf("   --server [server name] [port number]\n");
    return 0;
  }

  char* name = argv[2];
  int port = atoi(argv[3]);
  printf("Connecting to %s, on port %i\n", name, port);

  IPaddress ip;
  int error = SDLNet_ResolveHost(&ip, name, port);
  //SDLNet_ResolveHost(&ip, "localhost", port);
  if(error == -1) printf("\n\nerror on address resolution, program inconsistancy\n\n");

  NetworkManager* netMan = new NetworkManager();
  Synchronizeable* ss = new SimpleSync("Client\0");

  netMan->establishConnection(ip, *ss);

  for(;;) {
    netMan->synchronize();
    SDL_Delay(500);
  }

  //NetworkStream* client = new NetworkStream(ip, ss, NET_CLIENT);


  delete netMan;
  delete ss;

  return 0;
}



/**
 *
 *  main function
 *
 * here the journey begins
 */
int main(int argc, char** argv)
{
  int i;
  // here the pre-arguments are loaded, these are needed to go either to orxonx itself, Help, or Benchmark.
  for(i = 1; i < argc; ++i)
  {
    //else if(!strcmp( "--gui", argv[i]) || !strcmp("-g", argv[i])) showGui = true;
    if (! strcmp( "--sockettest", argv[i]) || !strcmp("-st", argv[i])) return testSocket(argc, argv);
    else if (! strcmp( "--frameworktest", argv[i]) || !strcmp("-ft", argv[i])) return testFramework(argc, argv);
    else if (! strcmp( "--server", argv[i]) || !strcmp("-s", argv[i])) return startServer(argc, argv);
    else if (! strcmp( "--client", argv[i]) || !strcmp("-c", argv[i])) return startClient(argc, argv);
  }

  startHelp(argc, argv);

  return 0;
}


bool ShellBuffer::addBufferLineStatic(const char* line, ...)
{
  //va_list arguments;
  //vprintf(line, arguments);
  printf("%s", line);

}
