/*
   orxonox - the future of 3D-vertical-scrollers

   Copyright (C) 2004 orx

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

### File Specific:
   main-programmer: claudio
   co-programmer:
*/


/* this is for debug output. It just says, that all calls to PRINT() belong to the DEBUG_MODULE_NETWORK module
   For more information refere to https://www.orxonox.net/cgi-bin/trac.cgi/wiki/DebugOutput
*/
#define DEBUG_MODULE_NETWORK


#include "base_object.h"
#include "network_protocol.h"
#include "network_socket.h"
#include "connection_monitor.h"
#include "synchronizeable.h"
#include "list.h"
#include "debug.h"

/* include your own header */
#include "network_stream.h"

/* probably unnecessary */
using namespace std;


#define PACKAGE_SIZE  256


NetworkStream::NetworkStream()
  : DataStream()
{
  this->init();
  /* initialize the references */
  this->networkSocket = new NetworkSocket();
  this->networkProtocol = new NetworkProtocol();
  this->synchronizeables = NULL;
  this->connectionMonitor = new ConnectionMonitor();
}


NetworkStream::NetworkStream(IPaddress& address, Synchronizeable& sync, NodeType type)
  : DataStream()
{
  this->init();
  this->networkSocket = new NetworkSocket(address);
  this->networkProtocol = new NetworkProtocol();
  this->synchronizeables = &sync;
  this->connectionMonitor = new ConnectionMonitor();
}


NetworkStream::NetworkStream(unsigned int port, Synchronizeable& sync, NodeType type)
  : DataStream()
{
  this->init();
  this->networkSocket = new NetworkSocket();
  this->networkSocket->listen(port);
  this->networkProtocol = new NetworkProtocol();
  this->synchronizeables = &sync;
  this->connectionMonitor = new ConnectionMonitor();
}


void NetworkStream::init()
{
  /* set the class id for the base object */
  this->setClassID(CL_NETWORK_STREAM, "NetworkStream");
  this->state = NET_REC_HEADER;
}


NetworkStream::~NetworkStream()
{

 networkSocket->disconnectServer();

 if( this->networkSocket)
   delete networkSocket;

 delete connectionMonitor;
 delete networkProtocol;
}

void NetworkStream::processData()
{
  int dataLength = 0;

  /* DOWNSTREAM */
  printf("\nSynchronizeable: %s\n", this->synchronizeables->getName());
  PRINT(0)("============= DOWNSTREAM:===============\n");
  /* first of all read the synchronizeable's data: */
  dataLength = this->synchronizeables->readBytes((byte*)downBuffer);

  /* send the received data to connectionMonitor */
  this->connectionMonitor->processPacket((byte*)downBuffer, dataLength);

  dataLength = this->networkProtocol->createHeader((byte*)downBuffer, dataLength, DATA_STREAM_BUFFER_SIZE,
      *(this->synchronizeables), 12/* some random number (no real id)*/);

  /* pass the data to the network socket */
  dataLength = this->networkSocket->writeBytes((byte*)downBuffer, dataLength);
  /* check if there was an error */
  if( dataLength == -1) { PRINTF(0)("Error in writing data to the NetworkSocket\n");}



  /* UPSTREAM */
  dataLength = 0;
  PRINT(0)("============== UPSTREAM:================\n");
  /* first of all read the next Orxonox Network Header */

  if( this->state == NET_REC_HEADER)
  {
    dataLength = this->networkSocket->readBlock((byte*)upBuffer, sizeof(Header));
    if( dataLength == sizeof(Header))
    {
      this->packetHeader = this->networkProtocol->extractHeader((byte*) upBuffer , dataLength);
      printf("NetworkStream::processData() - Got Header: Protocol %u, Version: %u, Sender: %u, Receiver: %u, Length: %u\n",
             this->packetHeader.protocol, this->packetHeader.version, this->packetHeader.senderID,
             this->packetHeader.receiverID, this->packetHeader.length);
      /* FIXME: what if it was no this->packetHeader? catch? eg: the protocol identifier, receiver id*/

      this->state = NET_REC_DATA;
    }
  }
  if( this->state == NET_REC_DATA)
  {
    /* now read the data */
    dataLength = this->networkSocket->readBlock((byte*)upBuffer, this->packetHeader.length);
    /* check if the data is available and process it if so */
    if( dataLength == this->packetHeader.length)
    {
      printf("NetworkStream::processData() - Got Data: \n");
      /* send the received data to connectionMonitor */
      this->connectionMonitor->processPacket((byte*)upBuffer, this->packetHeader.length);
      /* now pass the data to the sync object */
      this->synchronizeables->writeBytes((byte*)upBuffer, this->packetHeader.length);

      this->state = NET_REC_HEADER;
    }
  }


}
