/*!
 * @file network_manager.h
  *  Main interface for the network module. Manages all the modules
*/

/* you will want to add such a a line at your header file also, since it will
   prevent c++ from including your code twice*/
#ifndef _NETWORK_MANGER
#define _NETWORK_MANAGER

/* include this file, it contains some default definitions */
#include "netdefs.h"

/* include base_object.h since all classes are derived from this one */
#include "base_object.h"


/* forward declarations for the header file (include the header via #include "bla.h" in the source file) */
class NetworkStream;
class Synchronizeable;
template<typename> class tList;

/* and here is the class itsself*/
class NetworkManager : public BaseObject
{

public:

  NetworkManager();
  ~NetworkManager();

  void initialize();
  void shutdown();

  NetworkStream& establishConnection(IPaddress& address, Synchronizeable& sync);
  NetworkStream& establishConnection(const char& hostName, const Synchronizeable& sync);
  NetworkStream& createServer(Synchronizeable& sync, unsigned int port);
  void shutdownConnection();

  void synchronize();

private:
  std::list<BaseObject*>*    netStreamList;            // list with refs to all network streams
  std::list<BaseObject*>*    syncList;                 // list of synchronizeables

};



#endif /* _NETWORK_MANAGER */
