/*
   orxonox - the future of 3D-vertical-scrollers

   Copyright (C) 2004 orx

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   ### File Specific:
   main-programmer: Benjamin Knecht
   co-programmer: ...
*/

/* include Data_stream Header */
#include "data_stream.h"




/* using namespace std is default, this needs to be here */
using namespace std;



/**
 * This is the empty constructor
 */
DataStream::DataStream()
{
  this->setClassID(CL_DATA_STREAM, "DataStream");
  this->upBuffer = new byte[DATA_STREAM_BUFFER_SIZE];
  this->downBuffer = new byte[DATA_STREAM_BUFFER_SIZE];
}

/**
 * This constructor creates a new DataStream and connects it to both streams (upStream, downStream)
 */
DataStream::DataStream(DataStream& inStream, DataStream& outStream)
{
    this->setClassID(CL_DATA_STREAM, "DataStream");
    this->downStream = &outStream;
    this->upStream = &inStream;

    if( this->upBuffer)
      delete[] this->upBuffer;
    if( this->downBuffer)
      delete[] this->downBuffer;
}

/**
 *  standart deconstructor
 */
DataStream::~DataStream()
{

}


/**
 * This function connects this stream to another stream. The connected DataStream is an up-stream, meaning
 * that the stream is "further away" from the NetworkSocket. The local reference upStream will be set to this
 * Stream
 */
void DataStream::connectUpStream(DataStream& upStream)
{

}

/**
 * This function connects this stream to another stream. The connected DataStream is an down-stream, meaning
 * that the stream is "closer" to the NetworkSocket.
 */
void DataStream::connectDownStream(DataStream& upStream)
{

}

/**
 * This function disconnects the upStream and sets it to NULL
 */
void DataStream::disconnectUpStream()
{

}

/**
 * This function disconnects the downStream and sets it to NULL
 */
void DataStream::disconnectDownStream()
{

}


/**
 * Following functions are protected and only visible inside the object and from derived classes
 */

/**
 * This function writes the binary data to the local data. You will have to copy each byte and not only dublicate
 * it.
 *
 * @param data: the binary array
 * @param length: the length of the array
 */
void passDown(byte* data, int length)
{

}


/**
 * This function returns a reference to the local upData data array. So it can be read by an upper Stream
 * The reading function will have to copy the whole data and musn't just reference it!
 * This function is only called from other connected DataStreams to read the data.
 *
 * @param data: the binary array
 * @return: the length of the data
 */
int passUp(byte* data)
{

}
