/*!
 * @file connection_monitor.h
    \brief provides information about the quality of a connection.
 */

#ifndef _CONNECTION_MONITOR_H
#define _CONNECTION_MONITOR_H

#include "base_object.h"
#include "netdefs.h"

class ConnectionMonitor : virtual public BaseObject
  {
  public:
    ConnectionMonitor();
    ~ConnectionMonitor();

    void                processPacket(byte* packet, unsigned int packetLength);


  private:


    void                displayStatistic();
    void                computeCurrentDatarate();
    void                doUDPRelatedStuff();

    /*Data of the lifetime of the ConnectionMonitor Object*/
    unsigned int        packetToAverage;
    char*               protocollType;

    unsigned int        totalReceivedPackets;
    float               averageDatarate;
    unsigned int        totalLostPackets;
    float               totalPacketloss;
    unsigned int        startTime;

    /*Data of the current packet*/
    unsigned int        currentPacketID;
    unsigned int        currentPacketTick;
    unsigned int        lastPacketID;
    unsigned int        lastPacketTick;
    unsigned int        currentDelay;

    /*Data of the last n packets (n is specified by paxketsToAverage)*/
    unsigned int        sizeOfLastFewPackets;
    unsigned int        currentDatarate;
    byte**              lastFewPackets;
    unsigned int*       lastFewDelays;
    unsigned int        packetCounter;

  };

#endif
