/*
   orxonox - the future of 3D-vertical-scrollers

   Copyright (C) 2004 orx

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   ### File Specific
   main-programmer: Silvan Nellen
   co-programmer:

*/
#define DEBUG_SPECIAL_MODULE DEBUG_MODULE_WEAPON

#include "guided_missile.h"

#include "fast_factory.h"

#include "model.h"
#include "state.h"
#include "list.h"
#include "class_list.h"

#include "particle_engine.h"
#include "particle_emitter.h"
#include "particle_system.h"


#include "null_parent.h"

using namespace std;

CREATE_FAST_FACTORY_STATIC(GuidedMissile, CL_GUIDED_MISSILE);

/**
 *  standard constructor
*/
GuidedMissile::GuidedMissile () : Projectile()
{
  this->setClassID(CL_GUIDED_MISSILE, "GuidedMissile");

  float modelSize = .3;
  this->loadModel("models/projectiles/orx-rocket.obj", .3);

  this->energyMin = 1;
  this->energyMax = 10;
  this->lifeSpan = 5;
  this->agility = 5;
  this->maxVelocity = 100;

  this->emitter = new ParticleEmitter(Vector(0,1,0), M_2_PI, 100, 5);
  this->emitter->setParent(this);
  this->emitter->setSpread(M_PI, M_PI);
}


/**
 *  standard deconstructor
*/
GuidedMissile::~GuidedMissile ()
{
  // delete this->emitter;

  /* this is normaly done by World.cc by deleting the ParticleEngine */
  if (GuidedMissile::trailParticles != NULL && ClassList::getList(CL_TEST_BULLET)->size() <= 1)
  {
    if (ClassList::exists(GuidedMissile::trailParticles, CL_PARTICLE_SYSTEM))
      delete GuidedMissile::trailParticles;
    GuidedMissile::trailParticles = NULL;
  }
  if (GuidedMissile::explosionParticles != NULL && ClassList::getList(CL_TEST_BULLET)->size() <= 1)
  {
    if (ClassList::exists(GuidedMissile::explosionParticles, CL_PARTICLE_SYSTEM))
      delete GuidedMissile::explosionParticles;
    GuidedMissile::explosionParticles = NULL;
  }

}

ParticleSystem* GuidedMissile::trailParticles = NULL;
ParticleSystem* GuidedMissile::explosionParticles = NULL;



void GuidedMissile::activate()
{
  State::getWorldEntityList()->add(this);
  if (unlikely(GuidedMissile::trailParticles == NULL))
  {
    GuidedMissile::trailParticles = new ParticleSystem(2000, PARTICLE_SPRITE);
    GuidedMissile::trailParticles->setName("GuidedMissileTrailParticles");
    GuidedMissile::trailParticles->setMaterialTexture("maps/radial-trans-noise.png");
    GuidedMissile::trailParticles->setLifeSpan(1.0, .3);
    GuidedMissile::trailParticles->setRadius(0.0, .5);
    GuidedMissile::trailParticles->setRadius(0.2, 2.0);
    GuidedMissile::trailParticles->setRadius(.5, .8);
    GuidedMissile::trailParticles->setRadius(1.0, .8);
    GuidedMissile::trailParticles->setColor(0.0, 1,0,0,.7);
    GuidedMissile::trailParticles->setColor(0.2, .8,.8,0,.5);
    GuidedMissile::trailParticles->setColor(0.5, .8,.8,.8,.8);
    GuidedMissile::trailParticles->setColor(1.0, .8,.8,.8,.0);
  }
  if (unlikely(GuidedMissile::explosionParticles == NULL))
  {
    GuidedMissile::explosionParticles = new ParticleSystem(200, PARTICLE_SPRITE);
    GuidedMissile::explosionParticles->setName("GuidedMissileExplosionParticles");
    GuidedMissile::explosionParticles->setMaterialTexture("maps/radial-trans-noise.png");
    GuidedMissile::explosionParticles->setLifeSpan(.5, .3);
    GuidedMissile::explosionParticles->setRadius(0.0, 10);
    GuidedMissile::explosionParticles->setRadius(.5, 15.0);
    GuidedMissile::explosionParticles->setRadius(1.0, 10.0);
    GuidedMissile::explosionParticles->setColor(0.0, 0,1,0,1);
    GuidedMissile::explosionParticles->setColor(0.5, .8,.8,0,.8);
    GuidedMissile::explosionParticles->setColor(0.8, .8,.8,.3,.8);
    GuidedMissile::explosionParticles->setColor(1.0, 1,1,1,.0);
  }

  ParticleEngine::getInstance()->addConnection(this->emitter, GuidedMissile::trailParticles);

  this->updateNode(0);
  this->emitter->setEmissionRate(45.0);
  this->emitter->setEmissionVelocity(0.0);
}


void GuidedMissile::deactivate()
{
  ParticleEngine::getInstance()->breakConnections(this->emitter);
  this->lifeCycle = 0.0;

//  GarbageCollector::getInstance()->collect(this);
  State::getWorldEntityList()->remove(this);
  GuidedMissile::fastFactory->kill(this);
}


void GuidedMissile::collidesWith(WorldEntity* entity, const Vector& location)
{
  if (this->hitEntity != entity && entity->isA(CL_NPC))
    this->destroy();
  this->hitEntity = entity;
}

/**
 *  signal tick, time dependent things will be handled here
 * @param time since last tick
*/
void GuidedMissile::tick (float time)
{
  //Vector v = *this->flightDirection * ( this->speed * time * 1000 + 0.1);
  if (target != NULL && target->getParent() != NullParent::getInstance())
   {
     velocity += ((target->getAbsCoor() - this->getAbsCoor()).getNormalized())*agility;
     float speed = velocity.len();
     if (speed > this->maxVelocity)
       velocity *= maxVelocity/speed;

     this->setAbsDir(Quaternion(velocity, Vector(0,1,0)) * Quaternion ( -M_PI_2, Vector(0,1,0)));
   }
  Vector v = this->velocity * (time);
  this->shiftCoor(v);

  this->lifeCycle += time/this->lifeSpan;
  if( this->lifeCycle >= 1.0)
    {
      PRINTF(5)("FINALIZE==========================\n");
      PRINTF(5)("current life cycle is: %f\n", this->lifeCycle);
      PRINTF(5)("FINALIZE===========================\n");

      this->deactivate();
    }
}

/**
 *  the function gets called, when the projectile is destroyed
 */
void GuidedMissile::destroy ()
{
  PRINTF(5)("DESTROY GuidedMissile\n");
  this->lifeCycle = .95; //!< @todo calculate this usefully.
  ParticleEngine::getInstance()->breakConnection(this->emitter, GuidedMissile::trailParticles);
  ParticleEngine::getInstance()->addConnection(this->emitter, GuidedMissile::explosionParticles);

  this->emitter->setEmissionRate(1000.0);
  this->emitter->setEmissionVelocity(50.0);
//  this->deactivate();

}


void GuidedMissile::draw () const
{
  glMatrixMode(GL_MODELVIEW);
  glPushMatrix();

  float matrix[4][4];
  glTranslatef (this->getAbsCoor ().x, this->getAbsCoor ().y, this->getAbsCoor ().z);
  this->getAbsDir().matrix (matrix);
  glMultMatrixf((float*)matrix);
  glScalef(2.0, 2.0, 2.0);
  this->model->draw();

  glPopMatrix();

}

