/*
   orxonox - the future of 3D-vertical-scrollers

   Copyright (C) 2004 orx

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   ### File Specific:
   main-programmer: Benjamin Grauer
   co-programmer: ...
*/

#define DEBUG_SPECIAL_MODULE DEBUG_MODULE_ANIM

#include "animation.h"
#include "debug.h"
#include "animation_player.h"

/**
 *  creates a new Animation

   This also adds the Animation automatically to the AnimationPlayer's list
*/
Animation::Animation()
{
  this->setClassID(CL_ANIMATION, "Animation");

  // initialize a beginning KeyFrame, that will be deleted afterwards
  this->keyFrameCount = 0;
  this->bDelete = false;
  this->baseObject = NULL;

  // setting default values
  this->keyFramesToPlay = -1;
  this->localTime = 0.0;
  this->bRunning = false;

  AnimationPlayer::getInstance()->addAnimation(this);
}

/**
 *  destructs the Animation

   this also takes the animation out of the AnimationPlayer's list (if it is there)
*/
Animation::~Animation()
{
  AnimationPlayer::getInstance()->removeAnimation(this);
}


/**
 *  Sets the infinitymode
 * @param postInfinity How the Animation should advance after the last Keyframe
*/
void Animation::setInfinity(ANIM_INFINITY postInfinity)
{
  this->postInfinity = postInfinity;
}

/**
 *  handles the Animation if it gets out of boundraries eg. if animation is finished.
*/
void Animation::handleInfinity()
{
  switch (this->postInfinity)
    {
    case ANIM_INF_CONSTANT:
      this->localTime = 0.0;
      this->bRunning = false;
      break;
    case ANIM_INF_REPLAY:
      this->rewind();
      this->bRunning = true;
      break;
    case ANIM_INF_REWIND:
      this->stop();
      break;
    case ANIM_INF_DELETE: // this will possibly never be made
      this->bDelete = true;
      break;
    }
}

/**
 *  plays the animation back from the current Time forward
*/
void Animation::play()
{
  this->keyFramesToPlay = -1;
  this->bRunning = true;
}

/**
 *  plays the Next n keyframes
 * @param n the Count of keyFrames to play.
*/
void Animation::playNextKeyframes(int n)
{
  this->keyFramesToPlay = n-1;
  this->bRunning = true;
}

/**
 *  Stops the animation. eg. pause(); rewind();
*/
void Animation::stop()
{
  this->keyFramesToPlay = -1;
  this->rewind();
  this->bRunning = true;
  this->tick(0.0);
  this->bRunning = false;
}

/**
 *  Pauses the animation. Stays at the current Time
*/
void Animation::pause()
{
  this->bRunning = false;
}

/**
 *  replays the animation, eg. rewind();play();
*/
void Animation::replay()
{
  this->rewind();
  this->play();
}
