/*!
 * @file null_parent.h
  *  Definition of the NullParent, the higest PNode of them all.
*/


#ifndef _NULL_PARENT_H
#define _NULL_PARENT_H

#include "p_node.h"

//! The top joint of all PNode's every PNode is somehow connected to this one.
class NullParent : public PNode {

  public:
    /** @returns a Pointer to the only object of this Class */
    inline static NullParent* getInstance() { if (!singletonRef) singletonRef = new NullParent();  return singletonRef; };
    virtual ~NullParent ();

  private:
    NullParent (const Vector& absCoordinate = Vector(0.0, 0.0, 0.0));

  private:
    static NullParent* singletonRef;        //!< A reference to the NullParent

};

#endif /* _NULL_PARENT_H */
