

/*
   orxonox - the future of 3D-vertical-scrollers

   Copyright (C) 2004 orx

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   ### File Specific
   main-programmer: Patrick Boenzli
   co-programmer:
*/
#define DEBUG_SPECIAL_MODULE DEBUG_MODULE_WEAPON

#include "projectile.h"

#include "world_entity.h"
#include "weapon.h"
#include "null_parent.h"
#include "model.h"

#include "garbage_collector.h"

using namespace std;


/**
 *  standard constructor
*/
Projectile::Projectile () : WorldEntity()
{
  this->setClassID(CL_PROJECTILE, "Projectile");

  this->lifeCycle = 0.0;
  this->lifeSpan = 1.0f; /* sec */
  this->target = NULL;

  this->removeNode();
}


/**
 *  standard deconstructor
*/
Projectile::~Projectile ()
{
  /*
     do not delete the test projectModel, since it is pnode
     and will be cleaned out by world
  */
  //delete this->projectileModel;
}


void Projectile::setEnergies(float energyMin, float energyMax)
{
  this->energyMin = energyMin;
  if (energyMax <= energyMin)
  {
    this->bChargeable = false;
    this->energyMax = energyMin;
  }
  else
  {
    this->bChargeable = true;
    this->energyMax = energyMax;
  }
}


/**
 *  this sets the flight direction of the projectile
 * @param directin in which to flight

   this function will calculate a vector out of this to be used in the
   tick function
*/
void Projectile::setFlightDirection(const Quaternion& flightDirection)
{
  Vector v(1, 0, 0);
  this->flightDirection = flightDirection.apply(v);
  this->flightDirection.normalize();
}

/**
 *  sets the velocity vector to a spec speed
 * @param velocity: vector of the velocity
*/
void Projectile::setVelocity(const Vector &velocity)
{
  //Vector offsetVel =
  this->velocity = velocity;
 // offsetVel.normalize();
  //this->velocity += (offsetVel * 50.0);
}



void Projectile::setTarget(PNode* target)
{

  if (this->target == NULL)
     this->target = new PNode();
  this->target->setParent(target);
}


/**
 * signal tick, time dependent things will be handled here
 * @param time since last tick
*/
void Projectile::tick (float time)
{
  Vector v = this->velocity * (time);
  this->shiftCoor(v);

  this->lifeCycle += time/this->lifeSpan;
  if( this->lifeCycle >= 1)
  {
    PRINTF(5)("FINALIZE==========================\n");
    PRINTF(5)("current life cycle is: %f\n", this->lifeCycle);
    PRINTF(5)("FINALIZE===========================\n");
    //this->finalize();
    GarbageCollector::getInstance()->collect(this);
  }
}


/**
 *  the function gets called, when the projectile is destroyed
*/
void Projectile::destroy ()
{}


void Projectile::draw () const
{
  glMatrixMode(GL_MODELVIEW);
  glPushMatrix();

  float matrix[4][4];
  glTranslatef (this->getAbsCoor ().x, this->getAbsCoor ().y, this->getAbsCoor ().z);
  this->getAbsDir().matrix (matrix);
  glMultMatrixf((float*)matrix);
  this->model->draw();

  glPopMatrix();
}

