/*
   orxonox - the future of 3D-vertical-scrollers

   Copyright (C) 2004 orx

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   ### File Specific
   main-programmer: Benjamin Grauer
   co-programmer:
*/
#define DEBUG_SPECIAL_MODULE DEBUG_MODULE_WEAPON

#include "aiming_turret.h"

#include "weapon_manager.h"
#include "aim.h"
#include "projectile.h"

#include "model.h"

#include "null_parent.h"

#include "animation3d.h"
#include "sound_engine.h"

#include "factory.h"

CREATE_FACTORY(AimingTurret, CL_AIMING_TURRET);

using namespace std;


/**
 *  standard constructor

   creates a new weapon
*/
AimingTurret::AimingTurret ()
  : Weapon()
{
  this->init();

  this->loadModel("models/guns/turret2.obj");


  this->setActionSound(WA_SHOOT, "sound/shot1.wav");
  this->setActionSound(WA_ACTIVATE, "sound/vocals/missiles.wav");
  this->setActionSound(WA_RELOAD, "sound/vocals/reload.wav");
}


AimingTurret::AimingTurret(const TiXmlElement* root)
{
  this->init();
  this->loadParams(root);
}

/**
 *  standard deconstructor
*/
AimingTurret::~AimingTurret ()
{
  // model will be deleted from WorldEntity-destructor
//  delete this->target;
}

void AimingTurret::init()
{
  this->setClassID(CL_AIMING_TURRET, "AimingTurret");

  Animation3D* animation1 = this->getAnimation(WS_ACTIVATING, this);
  Animation3D* animation2 = this->getAnimation(WS_DEACTIVATING, this);

  animation1->addKeyFrame(Vector(0, -.5, 0), Quaternion(), 0.3, ANIM_LINEAR, ANIM_CONSTANT);
  animation1->addKeyFrame(Vector(0, 0, 0), Quaternion(), 0.3, ANIM_LINEAR, ANIM_CONSTANT);
  animation2->addKeyFrame(Vector(0, 0, 0), Quaternion(), 0.3, ANIM_LINEAR, ANIM_CONSTANT);
  animation2->addKeyFrame(Vector(0, -.5, 0), Quaternion(), 0.3, ANIM_LINEAR, ANIM_CONSTANT);

  animation1->setInfinity(ANIM_INF_CONSTANT);
  animation2->setInfinity(ANIM_INF_CONSTANT);

  this->setStateDuration(WS_SHOOTING, .1);
  this->setStateDuration(WS_RELOADING, .1);
  this->setStateDuration(WS_ACTIVATING, .4);
  this->setStateDuration(WS_DEACTIVATING, .4);

  this->setMaximumEnergy(10000, 50);
  this->increaseEnergy(100000);

  this->setCapability(WTYPE_ALLDIRS | WTYPE_TURRET);
  this->setProjectileType(CL_ROCKET);


  this->setEmissionPoint(1.684, 0.472, 0);
  //this->getProjectileFactory()->prepare(100);

  this->target = new Aim(this);
  this->target->setVisibility(false);
}

void AimingTurret::loadParams(const TiXmlElement* root)
{
  static_cast<Weapon*>(this)->loadParams(root);

}

void AimingTurret::activate()
{
  this->target->setVisibility(true);
}

void AimingTurret::deactivate()
{
  this->target->setVisibility(false);
}

void AimingTurret::tick(float dt)
{
  Quaternion quat;
  Vector direction = this->target->getAbsCoor() - this->getAbsCoor();

  direction.normalize();

  if (likely (this->getParent() != NULL))
    quat = Quaternion(direction, this->getParent()->getAbsDir().apply(Vector(0,1,0))) * Quaternion ( -M_PI_2, Vector(0,1,0)) ;
  else
    quat = Quaternion(direction, Vector(0,1,0)) * Quaternion ( -M_PI_2, Vector(0,1,0)) ;

  this->setAbsDirSoft(quat, 5);

  this->target->tick(dt);
}

void AimingTurret::fire()
{
  Projectile* pj = this->getProjectile();
  if (pj == NULL)
    return;

    pj->setVelocity(/*this->getVelocity()+*/(this->getAbsDir().apply(Vector(1,0,0))*250.0 + VECTOR_RAND(13)
            /*target->getAbsCoor() - this->getAbsCoor()*/)*.5);//this->getVelocity());

  pj->setParent(NullParent::getInstance());
  pj->setAbsCoor(this->getEmissionPoint());
  pj->setAbsDir(this->getAbsDir());
  pj->activate();
  this->target->searchTarget(100);
}

void AimingTurret::destroy ()
{}

/**
 * draws the AimingTurret
*/
void AimingTurret::draw () const
{
  /* draw gun body */
  glMatrixMode(GL_MODELVIEW);
  glPushMatrix();
  glTranslatef (this->getAbsCoor ().x,
                this->getAbsCoor ().y,
                this->getAbsCoor ().z);
  Vector tmpRot = this->getAbsDir().getSpacialAxis();
  glRotatef (this->getAbsDir().getSpacialAxisAngle(), tmpRot.x, tmpRot.y, tmpRot.z );

  this->model->draw();
  glPopMatrix();
}

