/*!
  \file texture.h
  \brief Contains the texture class, that handles the reading of Images into Texutre-files.

  @todo procedural textures
*/

#ifndef _TEXTURE_H
#define _TEXTURE_H

#include "glincl.h"
#include "base_object.h"

#include "debug.h"

struct SDL_Surface;

//! an enumerator for different procedural texture-types
typedef enum TEXTURE_TYPE { TEXTURE_RADIAL_ALIAS,
                            TEXTURE_NOISE };

//! A Class, that reads in Textures from different fileformats.
class Texture : public BaseObject
{
 public:
  Texture(const char* imageName = NULL);
  //  Texture(TEXTURE_TYPE type, int resolution);
  ~Texture();

  bool loadImage(const char* imageName);
  bool rebuild();

  /** @returns The textureID of this texture.  */
  inline GLuint getTexture() const { return this->texture; };
  /** @returns true if texture has alpha, false otherwise */
  inline bool hasAlpha() const {return bAlpha;}

 private:
  SDL_Surface* prepareSurface(SDL_Surface* input);
  GLuint loadTexToGL (SDL_Surface* surface) const;

 private:
  GLuint        texture;            //!< The Texture-ID of opengl from this Texture.
  bool          bAlpha;             //!< if the texture has an alpha channel.
  SDL_Surface*  image;   
};

#endif /* _TEXTURE_H */
