/*
   orxonox - the future of 3D-vertical-scrollers

   Copyright (C) 2004 orx

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.
   
   ### File Specific:
   main-programmer: Benjamin Wuest
   co-programmer: ...
*/

/* this is for debug output. It just says, that all calls to PRINT() belong to the DEBUG_MODULE_NETWORK module
   For more information refere to https://www.orxonox.net/cgi-bin/trac.cgi/wiki/DebugOutput
*/
#define DEBUG_MODULE_NETWORK

//#include ...

/* include my own header */
#include "network_protocol.h"

/* include the synchronizeable object */
#include "synchronizeable.h"

/* include this file for debugging */
#include "debug.h"

/* using namespace std is default, this needs to be here */
using namespace std;


/**
  standard constructor
*/
NetworkProtocol::NetworkProtocol()
{
  /* set the class id for the base object */
  this->setClassID(CL_NETWORK_PROTOCOL, "NetworkProtocol");
  this->headerLength = HEADER_LENGTH;
}

/**
  standard destructor
*/
NetworkProtocol::~NetworkProtocol()
{}

/**
    * creates a new packet header from the function arguments
    *
    * @arg data: the binary data without header -> return the data in this binary array
    * @arg length: the data length without header
    * @arg bufferLength: the length of the internal buffer
    * @arg source: reference to the source Synchronizeable object
    * @arg remoteID: id number of the remote Synchronizeable object
    * @return: the new data length with header (the header data is included into byte* data)
    *          -1 if there isn't enough space in the buffer for the header
*/
int NetworkProtocol::createHeader(byte* data, int length, int bufferLength, const Synchronizeable& source, unsigned int remoteID)
{
  PRINTF(0)("create header\n");
  printf("length = %i, bufferLength = %i\n", length, bufferLength);
  //If there isn't enough space for the header return -1
  if (length + headerLength > bufferLength)
    return -1;
  
  //Create space for the header
  for( int i = length - 1; i >= 0; i--)
    data[i + headerLength] = data[i];
  
  //Include header
  data[0] = 255;
}

/**
    * extracts the header from the binary data stream
    * @arg data: the binary data with the header
    * @arg length: the length of the binary data (including header)
    * @return: a Header struct with the header information and the binary data
*/
Header NetworkProtocol::extractHeader(byte* data, int length)
{
  PRINTF(0)("extract Header\n");
  //Test if received data can contain a header
  if (length < headerLength)
  {
    PRINTF(0)("Received data is to short; it can't contain a header!");
    Header h;
    h.protocol = 0;
    return h;
  }
  
  //Extract header
  Header h;
  h.protocol = data[0];
  
  h.length = length - headerLength;
  h.data = data;
  
  //Remove header
  for (int i = headerLength; i < length; i++)
    data[i - headerLength] = data[i];
  
  return h;
}
