/*
   orxonox - the future of 3D-vertical-scrollers

   Copyright (C) 2004 orx

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

### File Specific:
   main-programmer: Silvan Nellen
   co-programmer: ...
*/

#include "connection_monitor.h"
#include <debug.h>
#include <SDL/SDL.h>
#include <string.h>

/* using namespace std is default, this needs to be here */
using namespace std;

ConnectionMonitor::ConnectionMonitor()
{

  /* set the class id for the base object and add ist to class list*/
  this->setClassID(CL_CONNECTION_MONITOR, "ConnectionMonitor");

  /*initialize variables*/

  /*Data of the lifetime of the ConnectionMonitor Object*/
  packetToAverage = 100;
  protocollType = "default(TCP)";

  startTime= SDL_GetTicks();
  totalReceivedPackets=0;
  averageDatarate=0;
  totalLostPackets=0;
  totalPacketloss=0;

  /*Data of the current packet*/
  currentPacketID=0;
  currentPacketTick=0;
  lastPacketID=0;
  lastPacketTick=0;
  currentDelay=0;

  /*Data of the last n packets (n is specified by paxketsToAverage)*/
  sizeOfLastFewPackets=0;
  currentDatarate=0;
  lastFewDelays = new unsigned int [packetToAverage];
  lastFewPackets = new byte* [packetToAverage];
  packetCounter=0;


}


ConnectionMonitor::~ConnectionMonitor()
{


}



void ConnectionMonitor::processPacket(byte* currentPacket, unsigned int packetLength)
{
  /*Process the current Packet*/
  currentPacketTick = SDL_GetTicks();
  currentDelay = currentPacketTick - lastPacketTick;

  /*Do whats needed for Averaging*/

  if(packetCounter = packetToAverage)
    {
      computeCurrentDatarate();
      displayStatistic();
      packetCounter = 0;
      sizeOfLastFewPackets = 0;
    }

  lastFewDelays[packetCounter] = currentDelay;
  lastFewPackets[packetCounter] = currentPacket;
  sizeOfLastFewPackets += packetLength;

  /*Update the lifetime Variables*/
  totalReceivedPackets ++;
  averageDatarate = totalReceivedPackets/(currentPacketTick - startTime);

  /*Preparefor the next Packet*/
  lastPacketTick = currentPacketTick;
  packetCounter++;
}


/* Compute the value of current Datarate*/
void ConnectionMonitor::computeCurrentDatarate()
{
  int timeForLastFewPackets=0;
  for(int i=0;i < packetToAverage;i++)
    timeForLastFewPackets += lastFewDelays[i];

  if( timeForLastFewPackets != 0)
    currentDatarate = sizeOfLastFewPackets/timeForLastFewPackets;
}

void doUDPRelatedStuff()
{
  /*  Do protocol related stuff

  Only for Udp:
  "currentPacketID = getID from package";

  if(currentPacketID - lastPacketID > 1)
  {
  totalLostPackets += currentPacketID - lastPacketID;
}

  totalPacketloss = (totalLostPackets/totalReceivedPackets)*100 ;
  */
}



/* Display connectoin statistic*/
void ConnectionMonitor::displayStatistic()
{
  PRINT(0)("============================================\n");
  PRINT(0)("Connection Monitor Network Statistics:\n");
  PRINT(0)("Total received packets:",totalReceivedPackets);
  PRINT(0)("Average datarate :\n",averageDatarate);
  PRINT(0)("Total lost packets:",totalLostPackets);
  PRINT(0)("Packetloss [%] :\n",totalPacketloss);

  PRINT(0)("Current datarate :\n",currentDatarate);
  PRINT(0)("Delays of the last few packets :\n");
  for(int i=1 ;i <= packetToAverage-1;i++)
    PRINT(0)("%i ",lastFewDelays[i]);

  PRINT(0)("============================================\n");

}

