/*
   orxonox - the future of 3D-vertical-scrollers

   Copyright (C) 2004 orx

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

### File Specific:
   main-programmer: claudio
   co-programmer: 
*/


/* this is for debug output. It just says, that all calls to PRINT() belong to the DEBUG_MODULE_NETWORK module
   For more information refere to https://www.orxonox.net/cgi-bin/trac.cgi/wiki/DebugOutput
*/
#define DEBUG_MODULE_NETWORK
#define PACKAGE_SIZE  8

#include "base_object.h"
#include "network_protocol.h"
#include "network_socket.h"
#include "connection_monitor.h"
#include "synchronizeable.h"
#include "list.h"
#include "debug.h"

/* include your own header */
#include "network_stream.h"

/* probably unnecessary */
using namespace std;



NetworkStream::NetworkStream() 
  : DataStream()
{
  this->init();
  /* initialize the references */
  this->networkSocket = new NetworkSocket();
  this->synchronizeables = NULL;
  this->connectionMonitor = new ConnectionMonitor();
}


NetworkStream::NetworkStream(IPaddress& address, Synchronizeable& sync, NodeType type) 
  : DataStream()
{
  this->init();
  this->networkSocket = new NetworkSocket( address, 88 );
   // this->networkSocket->connectToServer(address, 88);

  this->synchronizeables = &sync;
}


NetworkStream::NetworkStream(Synchronizeable& sync, int port, NodeType type) 
  : DataStream()
{
  this->init();
  this->networkSocket = new NetworkSocket(/* address, type */);
 
  this->synchronizeables = &sync;
}


void NetworkStream::init()
{
  /* set the class id for the base object */
  this->setClassID(CL_NETWORK_STREAM, "NetworkStream");
}


NetworkStream::~NetworkStream()
{

 networkSocket->disconnectServer();

 delete networkSocket;
 delete connectionMonitor;

}

void NetworkStream::processData()
{

 
  int ret = 0;
  
  
  
  /* DOWNSTREAM */
  /* first of all read the synchronizeable's data: */

  ret = this->synchronizeables->readBytes((byte*)downBuffer);
  	this->connectionMonitor->processPacket((byte*)downBuffer, PACKAGE_SIZE);
	//this-> ->extractHeader(byte* data, int length);
  /* pass the data to the network socket */
  ret = this->networkSocket->writeBytes((byte*)downBuffer, PACKAGE_SIZE);
  /* check if there was an error */
  if( ret == -1) { PRINTF(0)("Error in writing data to the NetworkSocket\n");}
  
  
  /* UPSTREAM */
  /* first read 10bytes of data (debug) */

  ret = 0; 
  while(ret == 0)  ret = this->networkSocket->readBlock((byte*)upBuffer,PACKAGE_SIZE);
  /* error checking: data read? */
  if( ret != PACKAGE_SIZE) { PRINTF(0)("Error while reading data from the NetworkSocket\n");}
  /* now pass the data to the sync object */

  this->synchronizeables->writeBytes((byte*)upBuffer, PACKAGE_SIZE);

  
  

}

