/*!

*/

#ifndef _NETWORK_PROTOCOL_H
#define _NETWORK_PROTOCOL_H

#include "base_object.h"

/* include this file, it contains some default definitions */
#include "netdefs.h"

#define HEADER_LENGTH 1

typedef struct Header
{
  byte protocol;
  byte version;
  byte senderID;
  byte receiverID;
  byte length;
  byte* data;
};

class Synchronizeable;

/*!

*/
class NetworkProtocol : virtual public BaseObject
{
  public:
    NetworkProtocol();
    ~NetworkProtocol();

    int createHeader(byte* data, int length, int bufferLength, const Synchronizeable& source, unsigned int remoteID);
    Header extractHeader(byte* data, int length);

  private:
    unsigned int headerLength; //The Length of the Header in bytes
};

#endif //_NETWORK_PROTOCOL_H
