/*!
 * @file obb_tree.h
  *  Definition of an obb tree (object oriented Bounding Box)

*/

#ifndef _OBB_TREE_H
#define _OBB_TREE_H

#include "bv_tree.h"
#include "abstract_model.h"
#include "material.h"

class Material;
class OBBTreeNode;
class PNode;

//! A class for representing an obb tree
class OBBTree : public BVTree {

  public:
    OBBTree(int depth, sVec3D *verticesList, const int length);
    OBBTree(int depth, const modelInfo& modInfo);
    virtual ~OBBTree();
    void init();

    virtual void spawnBVTree(sVec3D *verticesList, const int length);
    virtual void spawnBVTree(const modelInfo& modelInf);
    virtual void flushTree();

    virtual void collideWith(BVTree* tree, WorldEntity* nodeA, WorldEntity* nodeB);
    virtual void collideWith(WorldEntity* entity1, WorldEntity* entity2);

    virtual void drawBV(int depth, int drawMode) const;

    int getID() { return ++this->id;}
    inline OBBTreeNode* getRootNode() { return this->rootNode; }

    void debug();

  private:
    OBBTreeNode*         rootNode;                        //!< reference to the root node of the tree
    int                  id;
    int                  depth;                           //!< the depth of the tree to generate
};

#endif /* _OBB_TREE_H */
