/*
   orxonox - the future of 3D-vertical-scrollers

   Copyright (C) 2004 orx

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

### File Specific:
   main-programmer: claudio
   co-programmer: 
*/


/* this is for debug output. It just says, that all calls to PRINT() belong to the DEBUG_MODULE_NETWORK module
   For more information refere to https://www.orxonox.net/cgi-bin/trac.cgi/wiki/DebugOutput
*/
#define DEBUG_MODULE_NETWORK


#include "base_object.h"
//#include "network_protocol.h"
#include "network_socket.h"
#include "connection_monitor.h"
#include "synchronizeable.h"
#include "list.h"
#include "debug.h"

/* include your own header */
#include "network_stream.h"

/* probably unnecessary */
using namespace std;



NetworkStream::NetworkStream() 
  : DataStream()
{
  this->init();
  /* initialize the references */
  this->networkSocket = new NetworkSocket();
  this->synchronizeables = new Synchronizeable();
  this->connectionMonitor = new ConnectionMonitor();
}


NetworkStream::NetworkStream(IPaddress& address, Synchronizeable& sync, NodeType type) 
  : DataStream(sync)
{
  this->init();
  this->networkSocket = new NetworkSocket(/* address, type */);
}


NetworkStream::NetworkStream(Synchronizeable& sync, int port, NodeType type) 
  : DataStream(sync)
{
  this->init();
  this->networkSocket = new NetworkSocket(/* address, type */);
}


void NetworkStream::init()
{
  /* set the class id for the base object */
  this->setClassID(CL_NETWORK_STREAM, "NetworkStream");
}


NetworkStream::~NetworkStream()
{
 delete networkSocket;
 delete synchronizeable;
 delete connectionMonitor;

}

void NetworkStream::processData()
{
  PRINTF(0)("process data\n");
 
  int ret = 0;
  
  byte downData[10];
  byte upData[10];
  
  /* DOWNSTREAM */
  /* first of all read the synchronizeable's data: */
  ret = this->synchronizeable->readBytes(downData);
  /* pass the data to the network socket */
  ret = this->networkSocket->writeBytes(downData, ret);
  /* check if there was an error */
  if( ret == -1) { PRINTF(0)("Error in writing data to the NetworkSocket\n");}
  
  
  /* UPSTREAM */
  /* first read 10bytes of data (debug) */
  ret = this->networkSocket->readBytes(upData, 0);
  /* error checking: data read? */
  if( ret != 10) { PRINTF(0)("Error while reading data from the NetworkSocket\n");}
  /* now pass the data to the sync object */
  this->synchronizeable->writeBytes(upData, 0);
  
  

}

