/*!
 * @file matrix.h
 * @brief Definition of a 3x3 matrix.
 */

#include <math.h>
#include "vector.h"


class Matrix
{

  public:
    Matrix() : m11(0), m12(0), m13(0), m21(0), m22(0), m23(0), m31(0), m32(0), m33(0) { };

    Matrix ( float m11, float m12, float m13,
             float m21, float m22, float m23,
             float m31, float m32, float m33 )
    {
      this->m11 = m11; this->m12 = m12; this->m13 = m13;
      this->m21 = m21; this->m22 = m22; this->m23 = m23;
      this->m31 = m31; this->m32 = m32; this->m33 = m33;
    };
    Matrix(const float m[3][3]) {
      this->m11 = m[0][0]; this->m12 = m[0][1]; this->m13 = m[0][2];
      this->m21 = m[1][0]; this->m22 = m[1][1]; this->m23 = m[1][2];
      this->m31 = m[2][0]; this->m32 = m[2][1]; this->m33 = m[2][2];
    };

    Matrix operator+ (const Matrix& m) const {
      return Matrix (this->m11 + m.m11, this->m12 + m.m12, this->m13 + m.m13,
                     this->m21 + m.m21, this->m22 + m.m22, this->m23 + m.m23,
                     this->m31 + m.m31, this->m32 + m.m32, this->m33 + m.m33);
    }

    Matrix operator- (const Matrix& m) const {
      return Matrix (this->m11 - m.m11, this->m12 - m.m12, this->m13 - m.m13,
                     this->m21 - m.m21, this->m22 - m.m22, this->m23 - m.m23,
                     this->m31 - m.m31, this->m32 - m.m32, this->m33 - m.m33);
    }

    Matrix operator* (float k) const {
      return Matrix(this->m11 - k, this->m12 - k, this->m13 - k,
                    this->m21 - k, this->m22 - k, this->m23 - k,
                    this->m31 - k, this->m32 - k, this->m33 - k);
    }

    Vector operator* (const Vector& v) const {
      return Vector (this->m11*v.x + this->m12*v.y + this->m13*v.z,
                     this->m21*v.x + this->m22*v.y + this->m23*v.z,
                     this->m31*v.x + this->m32*v.y + this->m33*v.z );
    }


    Matrix getTransposed() const {
      return Matrix( this->m11, this->m21, this->m31,
                     this->m12, this->m22, this->m32,
                     this->m13, this->m23, this->m33);
    }

    void toVectors(Vector& m1, Vector& m2, Vector& m3) const {
      m1 = Vector(this->m11, this->m12, this->m13);
      m2 = Vector(this->m21, this->m22, this->m23);
      m3 = Vector(this->m31, this->m32, this->m33);
    }

    int getEigenValues(Vector& eigenVectors) const;
    void getEigenVectors(Vector& a, Vector& b, Vector& c) const;

    /// @todo optimize
    static Matrix identity() { return Matrix (1,0,0, 0,1,0, 0,0,1); }

    void debug() const;


  public:
    float m11;    float m12;     float m13;
    float m21;    float m22;     float m23;
    float m31;    float m32;     float m33;

};
