/*
   orxonox - the future of 3D-vertical-scrollers

   Copyright (C) 2004 orx

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   ### File Specific:
   main-programmer: Benjamin Grauer
   co-programmer: ...
*/

#include "load_param_description.h"

#include "multi_type.h"
#include "list.h"
#include <stdarg.h>
#include "stdlibincl.h"
/**
 * @param paramName the name of the parameter to load
 */
LoadParamDescription::LoadParamDescription(const char* paramName)
{
  this->types = NULL;
  this->description = NULL;
  this->defaultValues = NULL;
  this->paramName = new char[strlen(paramName)+1];
  strcpy(this->paramName, paramName);
}

/**
 *  removes all the alocated memory
 */
LoadParamDescription::~LoadParamDescription()
{
  if (this->defaultValues != NULL)
  {
    for(int i = 0; i < this->paramCount; i++)
    {
      delete[] this->defaultValues[i];
    }
  }

  delete[] this->types;
  delete[] this->defaultValues;
  delete[] this->paramName;
  delete[] this->description;
}

/**
 * @param descriptionText The text to set as a description for this Parameter
 */
void LoadParamDescription::setDescription(const char* descriptionText)
{
  this->description = new char[strlen(descriptionText)+1];
  strcpy(this->description, descriptionText);
}

/**
 *  prints out this parameter, its input method and the description (if availiable)
 */
void LoadParamDescription::print() const
{
  PRINT(3)(" <%s>", this->paramName);
  for (int i = 0; i < this->paramCount; i++)
  {
    if (i > 0)
      PRINT(3)(",");
    // FIXME
    //     switch (this->types[i])
//     {
//       default:
//         PRINTF(3)("none");
//         break;
//       case ParameterBool:
//         PRINT(3)("bool");
//         break;
//       case ParameterChar:
//         PRINT(3)("char");
//         break;
//       case ParameterString:
//         PRINT(3)("string");
//         break;
//       case ParameterInt:
//         PRINT(3)("int");
//         break;
//       case ParameterUInt:
//         PRINT(3)("Uint");
//         break;
//       case ParameterFloat:
//         PRINT(3)("float");
//         break;
//       case ParameterLong:
//         PRINT(3)("long");
//         break;
//       case ParameterXML:
//         PRINT(3)("XML");
//         break;
//     }
  }
  PRINT(3)("</%s>", this->paramName);
  if (this->description)
    PRINT(3)(" -- %s", this->description);
  // default values
  if (this->paramCount > 0)
  {
    PRINT(3)(" (Default: ");
    for (int i = 0; i < this->paramCount; i++)
    {
      if (i > 0)
        PRINT(3)(", ");
      if (this->types[i] & MT_STRING)
      { // leave brackets !!
        PRINT(3)("\"%s\"", this->defaultValues[i]);
      }
      else
      {
        PRINT(3)("%s", this->defaultValues[i]);
      }
    }
    PRINT(3)(")");
  }
  PRINT(3)("\n");
}

/**
 *  A list, that holds all the classes that are loadable (classes not objects!!)
 */
tList<LoadClassDescription>* LoadClassDescription::classList = NULL;

/**
 *  if the description of Parameters should be executed
 */
bool LoadClassDescription::parametersDescription = false;

/**
 * @param className the name of the class to be loadable
 */
LoadClassDescription::LoadClassDescription(const char* className)
{
  this->className = new char[strlen(className)+1];
  strcpy(this->className, className);

  if (LoadClassDescription::classList == NULL)
    LoadClassDescription::classList = new tList<LoadClassDescription>;

  LoadClassDescription::classList->add(this);

  this->paramList = new tList<LoadParamDescription>;
}

/**
 *  deletes a classDescription (deletes all the parameterDescriptions as well
 */
LoadClassDescription::~LoadClassDescription()
{
  tIterator<LoadParamDescription>* iterator = this->paramList->getIterator();
  LoadParamDescription* enumParamDesc = iterator->firstElement();
  while (enumParamDesc)
  {
    delete enumParamDesc;
    enumParamDesc = iterator->nextElement();
  }
  delete iterator;
  delete this->paramList;

  delete[] this->className;
}

void LoadClassDescription::deleteAllDescriptions()
{
  if (LoadClassDescription::classList != NULL)
  {
    tIterator<LoadClassDescription>* iterator = LoadClassDescription::classList->getIterator();
    LoadClassDescription* delElem = iterator->firstElement();
    while (delElem != NULL)
    {
      delete delElem;
      delElem = iterator->nextElement();
    }
    delete iterator;
    delete LoadClassDescription::classList;
  }
  LoadClassDescription::classList = NULL;
}


/**
 *  adds a class to the list of loadable classes
 * @param className The name of the class to add

   this function searches for the className string, and if found just returns the appropriate Class.
   Otherwise it returns a new classDescription
 */
LoadClassDescription* LoadClassDescription::addClass(const char* className)
{
  if (LoadClassDescription::classList != NULL)
  {
    tIterator<LoadClassDescription>* iterator = LoadClassDescription::classList->getIterator();
    LoadClassDescription* enumClassDesc = iterator->firstElement();
    while (enumClassDesc)
    {
      if (!strcmp(enumClassDesc->className, className))
      {
        delete iterator;
        return enumClassDesc;
      }
      enumClassDesc = iterator->nextElement();
    }
    delete iterator;
  }
  return new LoadClassDescription(className);
}

/**
 *  does the same as addClass(const char* className), but with params
 * @param paramName the name of the parameter to add.
 */
LoadParamDescription* LoadClassDescription::addParam(const char* paramName)
{
  tIterator<LoadParamDescription>* iterator = this->paramList->getIterator();
  LoadParamDescription* enumParamDesc = iterator->firstElement();
  while (enumParamDesc)
  {
    if (!strcmp(enumParamDesc->paramName, paramName))
    {
      delete iterator;
          //return enumParamDesc;
      return NULL;
    }
    enumParamDesc = iterator->nextElement();
  }
  delete iterator;

  LoadParamDescription* newParam = new LoadParamDescription(paramName);

  this->paramList->add(newParam);
  return newParam;
}

/**
 *  prints out all loadable Classes, and their parameters
 * @param fileName prints the output to a File
 * @todo implement it
 */
void LoadClassDescription::printAll(const char* fileName)
{
  PRINT(3)("===============================================================\n");
  PRINT(3)(" Listing all the Loadable Options (loaded since Game started).\n\n");
  if (LoadClassDescription::classList != NULL)
  {
    tIterator<LoadClassDescription>* classIT = LoadClassDescription::classList->getIterator();
    LoadClassDescription* enumClassDesc = classIT->firstElement();
    while (enumClassDesc)
    {
      PRINT(3)("<%s>\n", enumClassDesc->className);
      tIterator<LoadParamDescription>* paramIT = enumClassDesc->paramList->getIterator();
      LoadParamDescription* enumParamDesc = paramIT->firstElement();
      while (enumParamDesc)
      {
        enumParamDesc->print();
        enumParamDesc = paramIT->nextElement();
      }
      delete paramIT;

      PRINT(3)("</%s>\n\n", enumClassDesc->className);
      enumClassDesc = classIT->nextElement();
    }
    delete classIT;
  }
  else
    PRINT(3)("no Classes defined so far\n");
  PRINT(3)("===============================================================\n");
}

/**
 * searches for classes, which beginn with classNameBegin
 * @param classNameBegin the beginning string of a Class
 * @return a NEW char-array with ClassNames. The LIST should be deleted afterwards,
 * !! The strings MUST NOT be deleted !!
 */
tList<const char>* LoadClassDescription::searchClassWithShort(const char* classNameBegin)
{
  unsigned int searchLength = strlen(classNameBegin);
  tList<const char>* retVal = new tList<const char>;

  tIterator<LoadClassDescription>* iterator = LoadClassDescription::classList->getIterator();
  LoadClassDescription* enumClassDesc = iterator->firstElement();
  while (enumClassDesc)
  {
    if (strlen(enumClassDesc->className)>searchLength+1 &&
        !strncasecmp(enumClassDesc->className, classNameBegin, searchLength))
    {
      retVal->add(enumClassDesc->className);
    }
    enumClassDesc = iterator->nextElement();
  }
  delete iterator;

  return retVal;
}
