

/*
   orxonox - the future of 3D-vertical-scrollers

   Copyright (C) 2004 orx

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   ### File Specific:
   main-programmer: Patrick Boenzli
   co-programmer:
*/
#define DEBUG_SPECIAL_MODULE DEBUG_MODULE_WORLD_ENTITY


#include "npc.h"
#include "obb_tree.h"

#include "state.h"
#include "list.h"
#include "stdlibincl.h"
#include "power_ups/turret_power_up.h"
#include "power_ups/laser_power_up.h"

using namespace std;


NPC::NPC()
{
  this->setClassID(CL_NPC, "NPC");

}


NPC::~NPC () {}


void NPC::collidesWith(WorldEntity* entity, const Vector& location)
{
  if (entity->isA(CL_PROJECTILE) && entity != this->collider)
  {
//    PRINTF(3)("collision %s vs %s @ (%f,%f,%f)\n", this->getName(), entity->getName(), location.x, location.y, location.z);
//    this->applyForce(Vector(0,0,0)-location*1000);
    if ((float)rand()/RAND_MAX < .3)
    {
      WorldEntity* powerUp = new TurretPowerUp();
      powerUp->setAbsCoor(this->getAbsCoor());
      State::getWorldEntityList()->add(powerUp);
    }
    else if ((float)rand()/RAND_MAX < .3)
    {
      WorldEntity* powerUp = new LaserPowerUp();
      powerUp->setAbsCoor(this->getAbsCoor());
      State::getWorldEntityList()->add(powerUp);
    }
    State::getWorldEntityList()->remove(this);

      this->collider = entity;
  }
  else if (entity->isA(CL_PLAYER))
    this->applyForce(Vector(0,0,0)-location*100);
  else if (entity->isA(CL_NPC))
  {
    this->setVisibiliy(false);
    State::getWorldEntityList()->remove(this);
  }
}


void NPC::tick(float dt)
{

}



