
#include <stdio.h>
#include <math.h>
#include "matrix.h"


Vector Matrix::getEigenValues() const
{
  Vector eigVl;

  float a = 0;
  float b = 0;

  float c[3];

  // c[0] is the determinante of mat
  c[0] = this->m11 * this->m22 * this->m33 +
      2* this->m12 * this->m13 * this->m23 -
      this->m11 * this->m23 * this->m23 -
      this->m22 * this->m13 * this->m13 -
      this->m33 * this->m12 * this->m12;

  // c[1] is the trace of a
  c[1] = this->m11 * this->m22 -
      this->m12 * this->m12 +
      this->m11 * this->m33 -
      this->m13 * this->m13 +
      this->m22 * this->m33 -
      this->m23 * this->m23;

  // c[2] is the sum of the diagonal elements
  c[2] = this->m11 +
      this->m22 +
      this->m33;


  // Computing the roots:
  a = (3.0*c[1] - c[2]*c[2]) / 3.0;
  b = (-2.0*c[2]*c[2]*c[2] + 9.0*c[1]*c[2] - 27.0*c[0]) / 27.0;

  float Q = b*b/4.0 + a*a*a/27.0;

  // 3 distinct Roots
  if (Q < 0)
  {
    float psi = atan2(sqrt(-Q), -b/2.0);
    float p = sqrt((b/2.0)*(b/2.0) - Q);

    eigVl.x = c[2]/3.0 + 2 * pow(p, 1/3.0) * cos(psi/3.0);
    eigVl.y = c[2]/3.0 - pow(p, 1/3.0) * (cos(psi/3.0)
        + sqrt(3.0) * sin(psi/3.0));
    eigVl.z = c[2]/3.0 - pow(p, 1/3.0) * (cos(psi/3.0)
        - sqrt(3.0) * sin(psi/3.0));

  }
  // 2 Distinct Roots
  else if (Q == 0)
  {
    eigVl.x = c[2]/3.0 + pow(b/2.0, 1.0/3.0);
    eigVl.y = c[2]/3.0 + pow(b/2.0, 1.0/3.0);
    eigVl.z = c[2]/3.0 + 2* pow(b/2.0, 1.0/3.0);
  }
  // 1 Root (not calculating anything.)
  else if (Q > 0)
  {
    printf("This Matrix is a multiple of the Identity matrix (lambda * I3))\n");
    eigVl.x = eigVl.y = eigVl.z = 1;
  }
  return eigVl;
}

void Matrix::getEigenVectors(Vector& a, Vector& b, Vector& c) const
{
  Vector eigVl = this->getEigenValues();

  float eigVal[3] = { eigVl.x, eigVl.y, eigVl.z };

  Vector eigVc[3];
  /* eigenvec test */
  for(int i = 0; i < 2; i++)
  {
    eigVc[i].x = -1/this->m13*(this->m33 - eigVal[i]) + (this->m32*(-this->m31*this->m32 + this->m12*this->m33 - this->m12*eigVal[i])) /
        this->m13*(-this->m13*this->m22 - this->m12*this->m23 + this->m13*eigVal[i]);

    eigVc[i].y = -( -this->m13*this->m23 + this->m12*this->m33 - this->m12*eigVal[i]) /
        (-this->m31*this->m22 + this->m12*this->m23 + this->m13*eigVal[i]);

    eigVc[i].z = 1.0f;

    eigVc[i] /= eigVc[i].len();
  }
  eigVc[2] = eigVc[0].cross(eigVc[1]);

  a = eigVc[0];
  b = eigVc[1];
  c = eigVc[2];
}

void Matrix::debug() const
{
  printf("| %f | %f | %f |\n", this->m11, this->m12, this->m13 );
  printf("| %f | %f | %f |\n", this->m21, this->m22, this->m23 );
  printf("| %f | %f | %f |\n", this->m31, this->m32, this->m33 );

}

