
#include <stdio.h>
#include <math.h>
#include "matrix.h"


class Vector
{
  public:
    Vector (float x, float y, float z) { this->x=x; this->y = y; this->z = z; };
  float x, y, z;
  inline Vector cross (const Vector& v) const { return Vector(y * v.z - z * v.y, z * v.x - x * v.z, x * v.y - y * v.x ); }
};

void Matrix::eigVl(const Matrix& mat)
{

  float eigValue[3];
  float eigVc[9];

  float a = 0;
  float b = 0;

  float c[3];

  // c[0] is the determinante of mat
  c[0] = this->m11 * this->m22 * this->m33 +
      2* this->m12 * this->m13 * this->m23 -
      this->m11 * this->m23 * this->m23 -
      this->m22 * this->m13 * this->m13 -
      this->m33 * this->m12 * this->m12;

  // c[1] is the trace of a
  c[1] = this->m11 * this->m22 -
      this->m12 * this->m12 +
      this->m11 * this->m33 -
      this->m13 * this->m13 +
      this->m22 * this->m33 -
      this->m23 * this->m23;

  // c[2] is the sum of the diagonal elements
  c[2] = this->m11 +
      this->m22 +
      this->m33;


  // Computing the roots:
  a = (3.0*c[1] - c[2]*c[2]) / 3.0;
  b = (-2.0*c[2]*c[2]*c[2] + 9.0*c[1]*c[2] - 27.0*c[0]) / 27.0;

  float Q = b*b/4.0 + a*a*a/27.0;

  // 3 distinct Roots
  if (Q < 0)
  {
    printf("good\n");
    float psi = atan2(sqrt(-Q), -b/2.0);
    float p = sqrt((b/2.0)*(b/2.0) - Q);

    eigValue[0] = c[2]/3.0 + 2 * pow(p, 1/3.0) * cos(psi/3.0);
    eigValue[1] = c[2]/3.0 - pow(p, 1/3.0) * (cos(psi/3.0)
        + sqrt(3.0) * sin(psi/3.0));
    eigValue[2] = c[2]/3.0 - pow(p, 1/3.0) * (cos(psi/3.0)
        - sqrt(3.0) * sin(psi/3.0));

  }
  // 2 Distinct Roots
  else if (Q == 0)
  {
    eigValue[0] = c[2]/3.0 + pow(b/2.0, 1.0/3.0);
    eigValue[1] = c[2]/3.0 + pow(b/2.0, 1.0/3.0);
    eigValue[2] = c[2]/3.0 + 2* pow(b/2.0, 1.0/3.0);
  }
  // 1 Root (not calculating anything.)
  else if (Q > 0)
  {
    printf("A is multiple of Identity matrix (lambda * I3))\n");
    eigValue[0] = eigValue[1] = eigValue[2] = 1;
  }

  Matrix M;

  float u11, u12, u13, u22, u23, u33;

  this->debug();

  printf("%f %f %f\n", eigValue[0], eigValue[1], eigValue[2]);

}


void Matrix::debug() const
{
  printf("input: | %f | %f | %f |\n", this->m11, this->m12, this->m13 );
  printf("       | %f | %f | %f |\n", this->m21, this->m22, this->m23 );
  printf("       | %f | %f | %f |\n", this->m31, this->m32, this->m33 );

}

