/*!
  \file substring.h
  \brief a small class to get the parts of a string separated by commas
*/

#ifndef _SUBSTRING_H
#define _SUBSTRING_H

//! A class that can load one string and split it in multipe ones
class SubString
{
 public:
  SubString(const char* string, char splitter = ',');
  SubString(const char* string, bool whiteSpaces);
  SubString(const char* string, const char* splitters, char escapeChar ='\\');
  ~SubString();

  inline unsigned int getCount() { return this->splittersCount; };
  const char* getString(unsigned int i);
  unsigned int getOffset(unsigned int i);

  void debug() const;

 private:
  char**          strings;                      //!< strings produced from a single string splitted in multiple strings
  unsigned int*   offsets;                      //!< offsets of the beginning of the input-string to the beginning of each substring.
  unsigned int    splittersCount;               //!< how many splitted parts
};

#endif /* _SUBSTRING_H */
