/*
   orxonox - the future of 3D-vertical-scrollers

   Copyright (C) 2004 orx

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   ### File Specific:
   main-programmer: ...
   co-programmer: ...
*/

//#define DEBUG_SPECIAL_MODULE DEBUG_MODULE_

#include "multi_type.h"
#include "stdincl.h"
// #include <stddef.h>
// #include <stdlib.h>
// #include <string.h>
// #include <stdio.h>

using namespace std;

/**
 * creates a multiType without any stored value at all.
 */
MultiType::MultiType()
{
  this->init();
}
/**
 * creates a multiType out of a boolean
 * @param value the Value of this MulitType
 */
MultiType::MultiType(bool value)
{
  this->init();
  this->setBool(value);
}

/**
 * creates a multiType out of an integer
 * @param value the Value of this MulitType
 */
MultiType::MultiType(int value)
{
  this->init();
  this->setInt(value);
}

/**
 * creates a multiType out of a float (double)
 * @param value the Value of this MulitType
 */
MultiType::MultiType(double value)
{
  this->init();
  this->setFloat(value);
}

/**
 * creates a multiType out of a char
 * @param value the Value of this MulitType
 */
MultiType::MultiType(char value)
{
  this->init();
  this->setChar(value);
}

/**
 * creates a multiType out of a String
 * @param value the Value of this MulitType
 */
MultiType::MultiType(const char* value)
{
  this->init();
  this->setString(value);
}

/**
 * standard deconstructor
*/
MultiType::~MultiType ()
{
  if (this->storedString != NULL)
    delete[] this->storedString;
}

/**
 * copy Constructor
 * @param mt: the entity to copy
 * @returns a Copy of itself. (strings inside are copied as well)
 */
// MultiType MultiType::operator= (const MultiType& mt)
// {
//   this->type = mt.type;
//   this->value = mt.value;
//
//   if (mt.type == MT_STRING && mt.storedString != NULL)
//   {
//     this->storedString = new char[strlen (mt.storedString)+1];
//     strcpy(this->storedString, mt.storedString);
//     this->value.String = this->storedString;
//   }
//   else
//     this->storedString = NULL;
//   return *this;
// }

/**
 * initializes the MultiType
 */
void MultiType::init()
{
  this->type = MT_NULL;
  this->storedString = NULL;
}



void MultiType::setType(int type)
{
  this->type = (MT_Type)type;

  if (this->type != type)
  {
    if (this->type == MT_NULL)
      this->setString("");

  }
  /// @todo check if this works...

}

/**
 * sets a new Value to the MultiType
 * @param value the new Value as a bool
 */
void MultiType::setBool(bool value)
{
  this->type = MT_BOOL;
  this->value.Bool = value;
}

/**
 * sets a new Value to the MultiType
 * @param value the new Value as an int
 */
void MultiType::setInt(int value)
{
  this->type = MT_INT;
  this->value.Int = value;
}

/**
 * sets a new Value to the MultiType
 * @param value the new Value as a float
 */
void MultiType::setFloat(float value)
{
  this->type = MT_FLOAT;
  this->value.Float = value;
}

/**
 * sets a new Value to the MultiType
 * @param value the new Value as a char
 */
void MultiType::setChar(char value)
{
  this->type = MT_CHAR;
  this->value.Char = value;
}

/**
 * sets a new Value to the MultiType
 * @param value the new Value as a String
 */
void MultiType::setString(const char* value)
{
  this->type = MT_STRING;

  if (this->storedString != NULL)
    delete[] this->storedString;

  if (value == NULL)
  {
    this->storedString = new char[1];
    this->storedString[0] = '\0';
    this->value.String = this->storedString;
    return;
  }
  else
  {
    this->storedString = new char[strlen(value)+1];
    strcpy(storedString, value);
    this->value.String = this->storedString;
  }
}





/**
 * @returns the Value of this MultiType as a int
 */
bool MultiType::getBool() const
{
  // default case:
  if (this->type & MT_BOOL)
    return this->value.Bool;
  // Special Cases:
  else if (this->type & MT_INT) return (this->value.Int == 0)? false : true;
  else if (this->type & MT_FLOAT) return (this->value.Float == 0.0f)? false : true;
  else if (this->type & MT_CHAR) return (this->value.Char == '\0')? false : true;
  else if (this->type & MT_STRING) return (!strncmp(this->value.String, "true", 4) || !strncmp(this->value.String, "TRUE", 4) || !strncmp(this->value.String, "1", 1))? true : false; //! @TODO make this better.

  return false;
}

/**
 * @returns the Value of this MultiType as a int
 */
int MultiType::getInt() const
{
  // default case:
  if (this->type & MT_INT)
    return this->value.Int;
  if (this->type & MT_BOOL) return (this->value.Bool)? 1 : 0;
  else if (this->type & MT_FLOAT) return (int) this->value.Float;
  else if (this->type & MT_CHAR) return (int) this->value.Char;
  else if (this->type & MT_STRING) {
    char* endPtr = NULL;
    int result = strtol(this->value.String, &endPtr, 10);
    if ( endPtr >= this->value.String && endPtr < this->value.String + strlen(this->value.String))
      return 0;
    else
      return result;
  }

  return 0;
}

/**
 * @returns the Value of this MultiType as a float
 */
float MultiType::getFloat() const
{
 // default case:
  if (this->type & MT_FLOAT)
    return this->value.Float;
  if (this->type & MT_BOOL) return (this->value.Bool == true)? 1.0f : 0.0f;
  else if (this->type & MT_INT) return (float) this->value.Int;
  else if (this->type & MT_CHAR) return (float) this->value.Char;
  else if (this->type & MT_STRING) {
    char* endPtr = NULL;
    double result = strtod(this->value.String, &endPtr);
    if ( endPtr >= this->value.String && endPtr < this->value.String + strlen(this->value.String))
      return 0.0f;
    else
      return result;
  }

  return 0.0f;
}


/**
 * @returns the Value of this MultiType as a char
 */
char MultiType::getChar() const
{
 // default case:
  if (this->type & MT_INT)
    return this->value.Int;
  if (this->type & MT_BOOL) return (this->value.Bool)? 'y' : 'n';
  else if (this->type & MT_INT) return (int) this->value.Int;
  else if (this->type & MT_FLOAT) return (char) this->value.Float;
  else if (this->type & MT_STRING) return *this->value.String;

  return '\0';
}

/**
 * @returns the Value of this MultiType as a String
 */
const char* MultiType::getString()
{
 // default case:
  if (this->type & MT_STRING)
    return (this->value.String != NULL)? this->value.String : "";
  else
  {
    if (this->type & MT_BOOL) return (this->value.Bool)? "true" : "false";
    char tmpString[128];
    if (this->storedString != NULL)
    {
      delete[] this->storedString;
      this->storedString = NULL;
    }
    if (this->type & MT_CHAR)
    {
      this->storedString = new char[2];
      this->storedString[0] = this->value.Char;
      this->storedString[1] = '\0';
      return this->storedString;
    }
    else if (this->type & MT_INT)
    {
      sprintf(tmpString, "%d", this->value.Int);
      this->storedString = new char[strlen(tmpString)+1];
      strcpy (this->storedString, tmpString);
      return this->storedString;
    }
    if (this->type & MT_FLOAT)
    {
      sprintf(tmpString, "%f", this->value.Float);
      this->storedString = new char[strlen (tmpString)+1];
      strcpy (this->storedString, tmpString);
      return this->storedString;
    }
  }

  return "";
}

/**
 * prints out some nice debug output
 */
void MultiType::debug()
{
  printf("MultiType of Type: %s is: BOOL: %d, INT: %d, FLOAT: %f, CHAR: %c, STRING %s\n",
         MultiType::MultiTypeToString(this->type),
         this->getBool(),
         this->getInt(),
         this->getFloat(),
         this->getChar(),
         this->getString()
  );


}

/**
 * converts a MT_Type into a String
 * @param type: the MT_Type
 * @returns: the Type as a constant String (do not delete)
 */
const char* MultiType::MultiTypeToString(MT_Type type)
{
  switch (type)
  {
   default:
    return "NONE";
   case MT_BOOL:
    return "bool";
   case MT_INT:
    return "int";
   case MT_FLOAT:
    return "float";
   case MT_CHAR:
    return "char";
   case MT_STRING:
    return "string";
  }
}

/**
 * converts a String into a MT_Type
 * @param type: the Type as a String
 * @returns: the Type as MT_Type
 */
MT_Type MultiType::StringToMultiType(const char* type)
{
  if (!strncmp(type, "bool", 4))
    return MT_BOOL;
  if (!strncmp(type, "int", 3))
    return MT_INT;
  if (!strncmp(type, "float", 5))
    return MT_FLOAT;
  if (!strncmp(type, "char", 4))
    return MT_CHAR;
  if (!strncmp(type, "string", 6))
    return MT_STRING;
}
