/*
   orxonox - the future of 3D-vertical-scrollers

   Copyright (C) 2004 orx

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   ### File Specific:
   main-programmer: Benjamin Grauer
   co-programmer: ...
*/

//#define DEBUG_SPECIAL_MODULE DEBUG_MODULE_

#include "executor.h"

#include "list.h"
#include "debug.h"
#include "class_list.h"

#include "key_names.h"
#include <stdarg.h>
#include <stdio.h>
#include <string.h>

using namespace std;

////////////////////////
// SHELL COMMAND BASE //
////////////////////////
/**
 * constructs and registers a new Command
 * @param commandName the name of the Command
 * @param className the name of the class to apply this command to
 * @param paramCount the count of parameters this command takes
 */
Executor::Executor(const char* commandName, const char* className, unsigned int paramCount, ...)
{
  this->setClassID(CL_EXECUTOR, "Executor");
  this->setName(commandName);

//  this->classID = classID;
  // handling parameters, and storing them:
  if (paramCount > FUNCTOR_MAX_ARGUMENTS)
    paramCount = FUNCTOR_MAX_ARGUMENTS;
  this->paramCount = paramCount;
  this->parameters = new unsigned int[paramCount];
  this->defaultValue = new MultiType[paramCount];

  va_list parameterList;
  va_start(parameterList, paramCount);

  // What Parameters we have got
  for (unsigned int i = 0; i < paramCount; i++)
    this->parameters[i] = va_arg(parameterList, int);
}

/**
 * deconstructs a Executor
 */
Executor::~Executor()
{
  delete[] this->parameters;
  delete[] this->defaultValue;
}

/**
 * lets a command be described
 * @param description the description of the Given command
 */
Executor* Executor::describe(const char* description)
{
  if (this == NULL)
    return NULL;
 else
 {
   this->description = description;
   return this;
 }
}

/**
 * sets default Values of the Commands
 * @param count how many default Values to set.
 * @param ... the default Values in order. They will be cast to the right type
 * @returns itself
 *
 * Be aware, that when you use this Function, you !!MUST!! match the input as
 * count, [EXACTLY THE SAME AS IF YOU WOULD CALL THE FUNCTION UP TO count ARGUMENTS]
 */
Executor* Executor::defaultValues(unsigned int count, ...)
{
  if (this == NULL)
    return NULL;
  if (count == 0)
    return this;
  if (count > this->paramCount)
    count = this->paramCount;

  va_list defaultList;
  va_start(defaultList, count);

  for (unsigned int i = 0; i < count; i++)
  {


    switch (this->parameters[i])
    {
      case ParameterBool:
        this->defaultValue[i].setInt(va_arg(defaultList, int));
        break;
      case ParameterChar:
        this->defaultValue[i].setChar((char)va_arg(defaultList, int));
        break;
      case ParameterString:
        this->defaultValue[i].setString(va_arg(defaultList, char*));
        break;
      case ParameterInt:
        this->defaultValue[i].setInt(va_arg(defaultList, int));
        break;
      case ParameterUInt:
        this->defaultValue[i].setInt((int)va_arg(defaultList, unsigned int));
        break;
      case ParameterFloat:
        this->defaultValue[i].setFloat(va_arg(defaultList, double));
        break;
      case ParameterLong:
        this->defaultValue[i].setInt((int) va_arg(defaultList, long));
        break;
      default:
        break;
    }
  }
  return this;
}

/**
 * prints out nice information about the Executor
 */
void Executor::debug()
{
/*  tIterator<ExecutorClass>* iteratorCL = ExecutorClass::commandClassList->getIterator();
  ExecutorClass* elemCL = iteratorCL->firstElement();
  while(elemCL != NULL)
  {
    PRINT(0)("Class:'%s' registered %d commands: \n", elemCL->className, elemCL->commandList->getSize());
    tIterator<Executor>* iterator = elemCL->commandList->getIterator();
    const Executor* elem = iterator->firstElement();
    while(elem != NULL)
    {
      PRINT(0)("  command:'%s' : params:%d: ", elem->getName(), elem->paramCount);
      for (unsigned int i = 0; i< elem->paramCount; i++)
       printf("%s ", Executor::paramToString(elem->parameters[i]));
      if (elem->description != NULL)
       printf("- %s", elem->description);
      printf("\n");

      elem = iterator->nextElement();
    }
    delete iterator;
    elemCL = iteratorCL->nextElement();
  }
  delete iteratorCL;*/
}
