/*!
 * @file multi_type.h
 * @brief Definition of ...
 */

#ifndef _MULTI_TYPE_H
#define _MULTI_TYPE_H

// FORWARD DECLARATION

//! An enumerator defining Types, that can be stored inside a MultiType.
typedef enum
{
  MT_NULL            = 0,                  //!< No Value at all.
  MT_BOOL            = 1,                  //!< A bool Value.
  MT_INT             = 2,                  //!< An int Value.
  MT_FLOAT           = 4,                  //!< A float Value.
  MT_CHAR            = 8,                  //!< A single char.
  MT_STRING          = 16,                 //!< An entire String.

} MT_Type;



//! A class that encapsulates multiple differen types.
/**
 * Only one Value can be Stored inside this Class, but it can have any type: @see MT_Type.
 */
class MultiType {

  public:
    MultiType();
    MultiType(bool value);
    MultiType(int value);
    MultiType(double value);
    MultiType(char value);
    MultiType(const char* value);
    virtual ~MultiType();

    MultiType operator= (const MultiType& mt);

    void setType(MT_Type);

    void setBool(bool value);
    void setInt(int value);
    void setFloat(float value);
    void setChar(char value);
    void setString(const char* value);

    inline void setValue(bool value) { this->setBool(value); };
    inline void setValue(int value) { this->setInt(value); };
    inline void setValue(float value) { this->setFloat(value); };
    inline void setValue(char value) { this->setChar(value); };
    inline void setValue(const char* value) { this->setString(value); };

    /** @returns the Type of the Value stored in this MultiType */
    inline MT_Type getType() const { return this->type; };


    /* RETRIEVING FUNCTIONS */
    bool getBool() const;
    int getInt() const;
    float getFloat() const;
    char getChar() const;
    const char* getString();


    void debug();

    static const char* MultiTypeToString(MT_Type type);
    static MT_Type StringToMultiType(const char* type);

  private:
    void init();


  private:
    MT_Type             type;
    union MultiTypeValue
    {
      bool              Bool;
      int               Int;
      float             Float;
      char              Char;
      char*             String;

    }                   value;

    char*               storedString;
};

#endif /* _MULTI_TYPE_H */
