/*
   orxonox - the future of 3D-vertical-scrollers

   Copyright (C) 2004 orx

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   ### File Specific:
   main-programmer: Benjamin Grauer
   co-programmer: ...
*/

/*!
 * @file load_param.h
 * A Class and macro-functions, that makes our lives easy to load-in parameters
 */

#ifndef _LOAD_PARAM_DESCRIPTION_H
#define _LOAD_PARAM_DESCRIPTION_H

#include "base_object.h"

// Forward Declaration //
template<class T> class tList;

/************************
*** DESCRIPTION STUFF ***
************************/
//! A class that handles the description of loadable parameters
class LoadParamDescription
{
  friend class LoadParamBase;
  friend class LoadClassDescription;
 public:
  LoadParamDescription(const char* paramName);
  ~LoadParamDescription();

  void setDescription(const char* descriptionText);
  /** @returns the descriptionString */
  const char* getDescription() { return this->description; };

  void print() const;
 private:
  char*         paramName;             //!< The name of the parameter.
  int           paramCount;            //!< The count of parameters.
  int*          types;                 //!< What kind of parameters does this function take ??
  char*         description;           //!< A longer description about this function.
  char**        defaultValues;         //!< The 'Default Values'.
};

//! A class for descriptions of a loadable module
class LoadClassDescription
{
  friend class LoadParamBase;
 public:
  LoadClassDescription(const char* className);
  ~LoadClassDescription();

  static LoadClassDescription* addClass(const char* className);
  LoadParamDescription* addParam(const char* paramName);

  static void deleteAllDescriptions();

  static void printAll(const char* fileName = NULL);
  static tList<const char>* searchClassWithShort(const char* classNameBegin);
//  static const LoadParamDescription* getClass(const char* className);

 private:
  static bool                          parametersDescription;  //!< if parameter-description should be enabled.
  static tList<LoadClassDescription>*  classList;              //!< a list, that holds all the loadable classes. (after one instance has been loaded)
  char*                                className;              //!< name of the class
  tList<LoadParamDescription>*         paramList;              //!< List of parameters this class knows.
};

#endif /* _LOAD_PARAM_DESCRIPTION_H */
