/*!
 * @file multi_type.h
 * @brief Definition of ...
*/

#ifndef _MULTI_TYPE_H
#define _MULTI_TYPE_H

// FORWARD DECLARATION

//! An enumerator defining Types, that can be stored inside a MultiType.
typedef enum
{
  MT_NULL            = 0,                  //!< No Value at all.
  MT_BOOL            = 1,                  //!< A bool Value.
  MT_INT             = 2,                  //!< An int Value.
  MT_FLOAT           = 4,                  //!< A float Value.
  MT_CHAR            = 8,                  //!< A single char.
  MT_STRING          = 16,                 //!< An entire String.

} MT_Type;



//! A class that encapsulates multiple differen types.
/**
 * Only one Value can be Stored inside this Class, but it can have any type: @see MT_Type.
 */
class MultiType {

 public:
   MultiType(bool value);
   MultiType(int value);
   MultiType(float value);
   MultiType(char value);
   MultiType(const char* value);
   virtual ~MultiType();
   void init();


  /** @returns the Type of the Value stored in this MultiType */
  inline MT_Type getType() const { return this->type; };

  bool getBool();
  int getInt();
  float getFloat();
  char getChar();
  const char* getString();


 private:
   MT_Type             type;
   union Type
   {
     bool             Bool;
     int              Int;
     float            Float;
     char             Char;
     char*            String;
   } value;

   char* storedString;
};

#endif /* _MULTI_TYPE_H */
