/*
   orxonox - the future of 3D-vertical-scrollers

   Copyright (C) 2004 orx

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   ### File Specific:
   main-programmer: ...
   co-programmer: ...
*/

//#define DEBUG_SPECIAL_MODULE DEBUG_MODULE_

#include "multi_type.h"
#include "stdincl.h"

using namespace std;

MultiType::MultiType(bool value)
{
  this->init();
  this->type = MT_BOOL;
  this->value.Bool = value;

}

MultiType::MultiType(int value)
{
  this->init();
  this->type = MT_INT;
  this->value.Int = value;
}


MultiType::MultiType(float value)
{
  this->init();
  this->type = MT_FLOAT;
  this->value.Float = value;
}


MultiType::MultiType(char value)
{
  this->init();
  this->type = MT_CHAR;
  this->value.Char = value;
}


MultiType::MultiType(const char* value)
{
  this->init();
  this->type = MT_STRING;
  this->value.String = new char[strlen(value)+1];
  strcpy(this->value.String, value);

  this->storedString = this->value.String;
}

/**
 * standard deconstructor
*/
MultiType::~MultiType ()
{
  if (this->storedString != NULL)
    delete this->storedString;
}

void MultiType::init()
{
  this->storedString = NULL;
}


bool MultiType::getBool()
{
  // default case:
  if (this->type & MT_BOOL)
    return this->value.Bool;
  // Special Cases:
  else if (this->type & MT_INT) return (this->value.Int == 0)? false : true;
  else if (this->type & MT_FLOAT) return (this->value.Float == 0.0f)? false : true;
  else if (this->type & MT_CHAR) return (this->value.Char == '\0')? false : true;
  else if (this->type & MT_STRING) return (!strncmp(this->value.String, "true", 4) || !strncmp(this->value.String, "TRUE", 4) || !strncmp(this->value.String, "1", 1))? true : false;
}


int MultiType::getInt()
{
  // default case:
  if (this->type & MT_INT)
    return this->value.Int;
  if (this->type & MT_BOOL) return (this->value.Bool)? 1 : 0;
  else if (this->type & MT_FLOAT) return (int) this->value.Float;
  else if (this->type & MT_CHAR) return (int) this->value.Char;
  else if (this->type & MT_STRING) return 1; //! @TODO
}


float MultiType::getFloat()
{
 // default case:
  if (this->type & MT_FLOAT) return this->value.Float;
    return this->value.Int;
  if (this->type & MT_BOOL) return (this->value.Bool)? 1.0f : 0.0f;
  else if (this->type & MT_INT) return (float) this->value.Int;
  else if (this->type & MT_CHAR) return (float) this->value.Char;
  else if (this->type & MT_STRING) return 1; //! @TODO
}


char MultiType::getChar()
{
 // default case:
  if (this->type & MT_INT)
    return this->value.Int;
  if (this->type & MT_BOOL) return (this->value.Bool)? 'y' : 'n';
  else if (this->type & MT_INT) return (int) this->value.Int;
  else if (this->type & MT_FLOAT) return (char) this->value.Float;
  else if (this->type & MT_STRING) return 1; //! @TODO
}

const char* MultiType::getString()
{
 // default case:
  if (this->type & MT_STRING)
    return this->value.String;
/*  else if (this->type & MT_BOOL) return (this->value.Bool)? 1 : 0;
  else if (this->type & MT_INT) return 1; //! @TODO
  else if (this->type & MT_FLOAT) return (int) this->value.Float;
  else if (this->type & MT_CHAR) return (int) this->value.Char;*/
}

