/*!
 * @file base_object.h
  *  Definition of the base object class.

    This is a global handler for all classes.
*/


#ifndef _BASE_OBJECT_H
#define _BASE_OBJECT_H

#include "class_id.h"
#include "debug.h"
#ifndef NULL
#define NULL     0    //!< NULL
#endif

class TiXmlElement;

//! A class all other classes are derived from
class BaseObject {

 public:
  BaseObject (const TiXmlElement* root = NULL);
  virtual ~BaseObject ();

  void loadParams(const TiXmlElement* root);
  void setName (const char* newName);
  /** returns the Name of this Object */
  inline const char* getName ()const { return this->objectName; };

  /** @returns the className of the corresponding Object */
  inline const char* getClassName() const { return this->className; };
  /** @returns the classID of the corresponding Object */
  inline int getClassID() const { return this->classID; };

  bool isA (long classID) const;
  bool isA (const char* className) const;
  void whatIs() const;

 protected:
  void setClassID(long classID, const char* className);

  private:
    const char*        className;        //!< the name of the class
    long               classID;          //!< this is the id from the class_id.h enumeration
    char*              objectName;       //!< The name of this object
};

#endif /* _BASE_OBJECT_H */
