/*!
 * @file world_entity.h
 * Definition of the basic WorldEntity
*/

#ifndef _WORLD_ENTITY_H
#define _WORLD_ENTITY_H

#include "p_node.h"
#include "model.h"

// FORWARD DECLARATION
class SoundBuffer;
class SoundSource;
class BVTree;

//class CharacterAttributes;


//! Basis-class all interactive stuff in the world is derived from
class WorldEntity : public PNode
{
 public:
  WorldEntity(const TiXmlElement* root = NULL);
  virtual ~WorldEntity ();

  void loadParams(const TiXmlElement* root);
  void loadModel(const char* fileName, float scaling = 1.0f);
  bool buildObbTree(unsigned int depth);

  /** @param visibility if the Entity should be visible (been draw) */
  void setVisibiliy (bool visibility) { this->bVisible = visibility; };
  /** @returns true if the entity is visible, false otherwise */
  bool isVisible() const { return this->bVisible; };



  virtual void postSpawn ();
  virtual void leftWorld ();

  virtual void tick (float time);
  virtual void draw () const;
  virtual void collidesWith (WorldEntity* entity, const Vector& location);

  void drawBVTree(unsigned int depth, int drawMode) const;
  /** @returns a reference to the obb tree of this worldentity */
  BVTree* getOBBTree() const { return this->obbTree; };

  /* @returns the Count of Faces on this WorldEntity */
  //unsigned int getFaceCount () const { return (this->model != NULL)?this->model->getFaceCount():0; };
  //  void addAbility(Ability* ability);
  //  void removeAbility(Ability* ability);
  //  void setCharacterAttributes(CharacterAttributes* charAttr);
  //  CharacterAttributes* getCharacterAttributes();


 protected:
  Model*                  model;            //!< The model that should be loaded for this entity.
  BVTree*                 obbTree;          //!< this is the obb tree reference needed for collision detection
  //  CharacterAttributes*    charAttr;         //!< the character attributes of a world_entity

 private:
  bool                    bCollide;         //!< If it should be considered for the collisiontest.
  bool                    bVisible;         //!< If it should be visible.
};

#endif /* _WORLD_ENTITY_H */
