/* 
   orxonox - the future of 3D-vertical-scrollers

   Copyright (C) 2004 orx

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software Foundation,
   Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.  


   ### File Specific:
   main-programmer: Benjamin Grauer

*/

#include "gui_flags.h"

/**
 *  Creates the Flags-Frame
*/
GuiFlags::GuiFlags()
{
  this->flagsFrame = new Frame("Orxonox-Startup-Flags:");
  this->flagsBox = new Box('v');

  this->flagsLabel = new Label();
  this->flagsLabel->setSize(260,60);
  this->flagsBox->fill(flagsLabel);
  this->shortFlags = new CheckButton("shortFlags");
  this->shortFlags->setDefaultValue(0);
  this->flagsBox->fill(shortFlags);

  this->flagsFrame->fill(flagsBox);
  this->setMainWidget(flagsFrame);
}

/**
 *  Destructs the Flags-stuff
*/
GuiFlags::~GuiFlags()
{
  // nothing to do here
}

/**
 *  Sets the Flags from widget downwards.
 * @param widget the Widget from which on to scan for deeper Options and their settings.
*/
void GuiFlags::setTextFromFlags(Widget* widget)
{
  FlagInfo flagInfo;
  flagInfo.shortFlags = this->shortFlags;
  flagInfo.flagsLabel = this->flagsLabel;

  this->flagsLabel->ereaseText();
  this->flagsLabel->appendText(executable);
  widget->walkThrough(GuiFlags::flagsText, &flagInfo, 0);
  //  flagsLabel->setTitle(flagText);
}

/** 
  *  this actually sets the flagtext, and appends it to flagText
  * @param widget like GuiFlags::setTextFromFlags(widget)
  * @param flagInfo Information aboout the Flag that should be updated.
*/
void GuiFlags::flagsText(Widget* widget, void* flagInfo)
{
  FlagInfo* info =(FlagInfo*)flagInfo;
  if(widget->optionType > GUI_NOTHING)
    if (static_cast<Option*>(widget)->value != static_cast<Option*>(widget)->defaultValue )
      {
	if(info->shortFlags->isActive() && static_cast<Option*>(widget)->flagNameShort)
	  {
	    info->flagsLabel->appendText(" -");
	    info->flagsLabel->appendText(static_cast<Option*>(widget)->flagNameShort);
	  }
	else if(!info->shortFlags->isActive() && static_cast<Option*>(widget)->flagName)
	  {
	    info->flagsLabel->appendText(" --");
	    info->flagsLabel->appendText(static_cast<Option*>(widget)->flagName);
	  }

	if(static_cast<Option*>(widget)->optionType > GUI_BOOL)
	  {
	    info->flagsLabel->appendText("=");
	    info->flagsLabel->appendInt(static_cast<Option*>(widget)->value);
	  }
      }
}
