/*!
    \projectile.h
  *  a projectile, that is been shooted by a weapon
*/

#ifndef _TEST_BULLET_H
#define _TEST_BULLET_H

#include "projectile.h"

class Vector;
class Weapon;
class ParticleSystem;
class ParticleEmitter;
class FastFactory;

class TestBullet : public Projectile
{
  public:
    TestBullet ();
    virtual ~TestBullet ();


    virtual void activate();
    virtual void deactivate();

    virtual void collidesWith(WorldEntity* entity, const Vector& location);

    virtual void destroy ();

    virtual void tick (float time);
    virtual void draw ();


  private:
    static FastFactory*               fastFactory;
    static ParticleSystem*            trailParticles;
    static ParticleSystem*            explosionParticles;

    ParticleEmitter*                  emitter;


    WorldEntity* hitEntity; // FIXME TEMPORARY

};

#endif /* _TEST_BULLET_H */
