/*!
 * @file projectile.h
  *  a projectile, that is been shooted by a weapon

    You can use this class to make some shoots, but this isn't the real idea. If you want to just test, if the
    shooting funcions work, use the Projectile class. But if you want to implement your own shoots its
    different:<br>
    Make a new class and derive it from Projectile. To have a weapon work well, reimplement the functions
    - void tick()
    - void draw()
    - void hit() (only if you have working collision detection)
    When you have implemented these functions you have just to add the projectiles to your weapon. You ll want
    to make this by looking into the function
    - Weapon::fire()
    there you just change the line:
    Projectile* pj = new Projectile();    TO     Projectile* pj = new MyOwnProjectileClass();
    and schwups it works... :)
*/

#ifndef _PROJECTILE_H
#define _PROJECTILE_H

#include "world_entity.h"

class FastFactory;

class Projectile : public WorldEntity
{
  public:
    Projectile ();
    virtual ~Projectile ();

    void setFlightDirection(const Quaternion& flightDirection);
    void setVelocity(const Vector &velocity);
    void setLifeSpan(float lifeSpan);


    void setEnergies(float energyMin, float energyMax);
    /** @returns the minimal charched energy */
    inline float getEnergyMin() { return this->energyMin; };
    /** @returns the maximal charched energy */
    inline float getEnergyMax() { return this->energyMax; };
    /** @returns if the Projectile can be charged */
    inline bool isChageable() { return this->bChargeable; };


    /** @brief This is called, when the Projectile is Emitted */
    virtual void activate() = 0;
    /** @brief This is called, when the Projectile is being destroyed, or deleted */
    virtual void deactivate() = 0;

    virtual void destroy ();

    virtual void tick (float time);
    virtual void draw ();

  protected:
    // energy
    float                 energyMin;
    float                 energyMax;
    bool                  bChargeable;               //!< if the Projectile is Charegeable

    float                 lifeCycle;                 //!< The percentage of the Lifetime done [0-1]
    float                 lifeSpan;                  //!< The entire lifespan of the Shoot. in seconds

    Vector                flightDirection;           //!< DOF direction in which the shoot flighs

    Vector                velocity;                  //!< velocity of the projectile.
};

#endif /* _PROJECTILE_H */
