/*
   orxonox - the future of 3D-vertical-scrollers

   Copyright (C) 2004 orx

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   ### File Specific:
   main-programmer: Patrick Boenzli
   co-programmer:
*/

/*!
 * @file abstract_model.h
 *  Definition of an abstract model. containing all needed for other model
 */

#ifndef _ABSTRACT_MODEL_H
#define _ABSTRACT_MODEL_H

#include "base_object.h"


using namespace std;

class Quadtree;


//! this is a small and performant 3D vector
typedef float sVec3D[3];


//! small and performant 2D vector
typedef float sVec2D[2];


//! compressed vertex data: char insetead of float, the value will be expanded by the scale value. only for loading
typedef struct
{
  char             v[3];                 //!< the vector of the vertex
  unsigned char    lightNormalIndex;     //!< the index of the light normal
} sVertex;


//! compressed texture offset data: coords scaled by the texture size. Only for loading
typedef struct
{
  short            s;                    //!< the s,t coordinates of a texture
  short            t;                    //!< the s,t coordinates of a texture
} sTexCoor;


//! holds tha informations about a md2 frame
typedef struct
{
  sVec3D           scale;                //!< scales values of the model
  sVec3D           translate;            //!< translates the model
  char             name[16];             //!< frame name: something like "run32"
  sVertex          pVertices[1];         //!< first vertex of thes frame
} sFrame;


//! holds the information about a triangle
typedef struct
{
  unsigned short   indexToVertices[3];   //!< index to the verteces of the triangle
  unsigned short   indexToTexCoor[3];    //!< index to the texture coordinates
} sTriangle;


//! holds the information about a triangle
typedef struct
{
  unsigned int   indexToVertices[3];   //!< index to the verteces of the triangle
  unsigned int   indexToNormals[3];    //!< index to the normals of the triangle
  unsigned int   indexToTexCoor[3];    //!< index to the texture coordinates
} sTriangleExt;


//! the command list of the md2 model, very md2 specific
typedef struct
{
  float            s;                    //!< texture coordinate 1
  float            t;                    //!< texture coordinate 2
  int              vertexIndex;          //!< index of the vertex in the vertex list
} glCommandVertex;


//! a md2 animation definition
typedef struct
{
  int              firstFrame;           //!< first frame of the animation
  int              lastFrame;            //!< last frame of the animation
  int              fps;                  //!< speed: number of frames per second
} sAnim;


//! animation state definition
typedef struct
{
  int              startFrame;           //!< the start frame of an animation
  int              endFrame;             //!< last frame of the animation
  int              fps;                  //!< fps of the animaion (speed)

  float            localTime;            //!< the local time
  float            lastTime;             //!< last time stamp
  float            interpolationState;   //!< the state of the animation [0..1]

  int              type;                 //!< animation type

  int              currentFrame;         //!< the current frame
  int              nextFrame;            //!< the next frame in the list
} sAnimState;

//! Model Information definitions
typedef struct
{
  unsigned int     numVertices;          //!< number of Vertices in the Model
  unsigned int     numTriangles;         //!< number of triangles in the Model
  unsigned int     numNormals;           //!< how many Normals in the Model
  unsigned int     numTexCoor;

  const float*     pVertices;            //!< array of the Vertives
  sTriangleExt*    pTriangles;           //!< array of all triangles
  const float*     pNormals;             //!< array of the Normals
  const float*     pTexCoor;             //!< array of the Texture Coordinates

} modelInfo;



//! This class defines the basic components of a model
class AbstractModel : public BaseObject {

  public:
    AbstractModel() {}
    virtual ~AbstractModel() {}

    inline const modelInfo* getModelInfo() const { return this->pModelInfo; }


  protected:
    modelInfo*     pModelInfo;      //!< Reference to the modelInfo
};

#endif /* _ABSTRACT_MODEL_H */
