/*!
 * @file world.h
  *  Holds and manages all game data
*/

#ifndef _WORLD_H
#define _WORLD_H

#include "stdincl.h"
#include "comincl.h"
#include "story_entity.h"
#include "p_node.h"

class World;
class WorldEntity;
class Camera;
class Player;
class PNode;
class GLMenuImageScreen;
class Terrain;
class GarbageCollector;
class Text;
class TiXmlElement;
class PilotNode;

class Shell;
class OggPlayer;

//! The game world
/**
   this class initializes everything that should be displayed inside of the current level.
   it is the main driving factor during gameplay.
*/
class World : public StoryEntity {

 public:
  World (const char* name);
  World (int worldID);
  World (const TiXmlElement* root = NULL);
  virtual ~World ();

  void loadParams(const TiXmlElement* root);

  double getGameTime();

  /* classes from story-entity */
  virtual ErrorMessage preLoad();
  virtual ErrorMessage load ();
  virtual ErrorMessage init ();
  virtual ErrorMessage start ();
  virtual ErrorMessage stop ();
  virtual ErrorMessage pause ();
  virtual ErrorMessage resume ();
  virtual ErrorMessage destroy ();

  void loadDebugWorld(int worldID);

  virtual void displayLoadScreen();
  virtual void releaseLoadScreen();

  /* command node functions */
  bool command (Command* cmd);

  tList<WorldEntity>* getEntities();

  /* interface to world */
  void spawn (WorldEntity* entity);
  void spawn (WorldEntity* entity, Vector* absCoor, Quaternion* absDir);
  void spawn(WorldEntity* entity, PNode* parentNode, Vector* relCoor, Quaternion* relDir);

  /** @param speed sets the speed of the Game */
  inline void setSpeed(float speed) { this->speed = speed; };
  const char* getPath();
  void setPath( const char* name);

  inline Camera* getLocalCamera() { return this->localCamera; };

  void togglePNodeVisibility() { this->showPNodes = !this->showPNodes; };
  void toggleBVVisibility() { this->showBV = !this->showBV; };

 private:
  void constuctorInit(const char* name, int worldID);
  /* function for main-loop */
  void mainLoop ();
  void synchronize ();
  void handleInput ();
  void tick ();
  void update ();
  void collide ();
  void draw ();
  void display ();
  void debug ();

  private:
    bool   showPNodes;                  //!< if the PNodes should be visible.
    bool   showBV;                      //!< if the Bounding Volumes should be visible.
    Uint32 lastFrame;                   //!< last time of frame
    Uint32 cycle;                       //!< The cycle we are in (starts with 0 and rises with every frame)
    Uint32 dt;                          //!< time needed to calculate this frame (in milliSeconds)
    float dtS;                          //!< The time needed for caluculations in seconds
    float speed;                        //!< how fast the game flows
    double gameTime;                    //!< this is where the game time is saved
    bool bQuitOrxonox;                  //!< quit this application
    bool bQuitCurrentGame;              //!< quit only the current game and return to menu
    bool bPause;                        //!< pause mode

    GLMenuImageScreen* glmis;           //!< The Level-Loader Display

    int debugWorldNr;                   //!< The Debug Nr. needed, if something goes wrong
    char* path;                         //!< The file from which this world is loaded

    Shell*     shell;
    OggPlayer* music;

  // IMPORTANT WORLD-ENTITIES
    Camera* localCamera;                //!< The current Camera
    WorldEntity* sky;                   //!< The Environmental Heaven of orxonox @todo insert this to environment insted
    Terrain* terrain;                   //!< The Terrain of the World.

    GLuint objectList;                  //!< temporary: @todo this will be ereased soon
    tList<WorldEntity>* entities;       //!< A template List of all entities. Every moving thing should be included here, and world automatically updates them.
    Player* localPlayer;                //!< The Player, you fly through the level.
    PilotNode* pilotNode;               //!< THe pilot node to fly with the mouse


};

#endif /* _WORLD_H */
