/*
   orxonox - the future of 3D-vertical-scrollers

   Copyright (C) 2004 orx

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   ### File Specific:
   main-programmer: Benjamin Grauer
   co-programmer: ...
*/

#define DEBUG_SPECIAL_MODULE DEBUG_MODULE_GUI

#include "glgui_pushbutton.h"

#include "text.h"
#include "material.h"

using namespace std;

/**
 * standard constructor
*/
GLGuiPushButton::GLGuiPushButton ()
{
  this->init();
}


/**
 * standard deconstructor
*/
GLGuiPushButton::~GLGuiPushButton()
{

}

/**
 * initializes the GUI-element
 */
void GLGuiPushButton::init()
{
  this->setClassID(CL_GLGUI_PUSHBUTTON, "GLGuiPushButton");
//  this->label->setRelCoor2D(10, 10);

  this->backMat = new Material();
  this->backMat->setDiffuse(0, 0, 0);

  this->setSize2D(label->getSizeX2D()+10, label->getSizeY2D()+10);
}

/**
 * draws the GLGuiPushButton
 */
void GLGuiPushButton::draw() const
{
  this->backMat->select();
  glPushMatrix();
  glTranslatef(this->getAbsCoor2D().x, this->getAbsCoor2D().y, 0);
  glBegin(GL_QUADS);

  glVertex2d(0,0);
  glVertex2d(0, this->getSizeY2D());
  glVertex2d(this->getSizeX2D(), this->getSizeY2D());
  glVertex2d(this->getSizeX2D(),0);

  glEnd();
  glPopMatrix();

//   this->label->draw();
//  printf("test");
}

/**
 * updates the GLGuiPushButton
 */
void GLGuiPushButton::update()
{

}
