/*
   orxonox - the future of 3D-vertical-scrollers

   Copyright (C) 2004 orx

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   ### File Specific
   main-programmer: Benjamin Grauer
   co-programmer:
*/
#define DEBUG_SPECIAL_MODULE DEBUG_MODULE_WEAPON

#include "turret.h"

#include "weapon_manager.h"
#include "test_bullet.h"

#include "null_parent.h"
#include "state.h"
#include "vector.h"
#include "list.h"
#include "animation3d.h"
#include "sound_engine.h"

#include "factory.h"

CREATE_FACTORY(Turret);

using namespace std;


/**
 *  standard constructor

   creates a new weapon
*/
Turret::Turret (WeaponManager* weaponManager)
  : Weapon(weaponManager)
{
  this->init();

  this->loadModel("models/guns/turret1.obj");


  this->setActionSound(WA_SHOOT, "sound/shot1.wav");
  this->setActionSound(WA_ACTIVATE, "sound/vocals/missiles.wav");
  this->setActionSound(WA_RELOAD, "sound/vocals/reload.wav");
}


Turret::Turret(const TiXmlElement* root)
{
  this->init();
  this->loadParams(root);
}

/**
 *  standard deconstructor
*/
Turret::~Turret ()
{
  // model will be deleted from WorldEntity-destructor
}

void Turret::init()
{
  this->setClassID(CL_TURRET, "Turret");

  Animation3D* animation1 = this->getAnimation(WS_ACTIVATING, this);
  Animation3D* animation2 = this->getAnimation(WS_DEACTIVATING, this);

  animation1->addKeyFrame(Vector(0, -.5, 0), Quaternion(), 0.3, ANIM_LINEAR, ANIM_CONSTANT);
  animation1->addKeyFrame(Vector(0, 0, 0), Quaternion(), 0.3, ANIM_LINEAR, ANIM_CONSTANT);
  animation2->addKeyFrame(Vector(0, 0, 0), Quaternion(), 0.3, ANIM_LINEAR, ANIM_CONSTANT);
  animation2->addKeyFrame(Vector(0, -.5, 0), Quaternion(), 0.3, ANIM_LINEAR, ANIM_CONSTANT);

  animation1->setInfinity(ANIM_INF_CONSTANT);
  animation2->setInfinity(ANIM_INF_CONSTANT);

  this->setStateDuration(WS_SHOOTING, .1);
  this->setStateDuration(WS_RELOADING, .1);
  this->setStateDuration(WS_ACTIVATING, .4);
  this->setStateDuration(WS_DEACTIVATING, .4);

  this->setMaximumEnergy(10000, 50);
  this->increaseEnergy(100000);
  //this->minCharge = 2;


  this->setProjectileType(CL_TEST_BULLET);


  this->setEmissionPoint(1.684, 0.472, 0);
  //this->getProjectileFactory()->prepare(100);


}

void Turret::loadParams(const TiXmlElement* root)
{
  static_cast<Weapon*>(this)->loadParams(root);

}

void Turret::activate()
{
}

void Turret::deactivate()
{
}

void Turret::tick(float dt)
{
  Quaternion quat;
  Vector direction = this->getWeaponManager()->getFixedTarget()->getAbsCoor() - this->getAbsCoor();

  direction.normalize();

  if (likely (this->getParent() != NULL))
    quat = Quaternion(direction, this->getParent()->getAbsDir().apply(Vector(0,1,0))) * Quaternion ( -M_PI_2, Vector(0,1,0)) ;
  else
    quat = Quaternion(direction, Vector(0,1,0)) * Quaternion ( -M_PI_2, Vector(0,1,0)) ;

  this->setAbsDirSoft(quat, 5);
}

void Turret::fire()
{
  Projectile* pj = this->getProjectile();
  if (pj == NULL)
    return;

  PNode* target = this->getWeaponManager()->getFixedTarget();

  if (target != NULL)
  {
    pj->setVelocity(this->getVelocity()+(this->getAbsDir().apply(Vector(1,0,0))*100.0   /*target->getAbsCoor() - this->getAbsCoor()*/)*.5);//this->getVelocity());
  }
  else
    pj->setVelocity(target->getVelocity());

  pj->setParent(NullParent::getInstance());
  pj->setAbsCoor(this->getEmissionPoint());
  pj->setAbsDir(this->getAbsDir());
  State::getWorldEntityList()->add(pj);
}


void Turret::destroy ()
{}

/**
 * draws the Turret
*/
void Turret::draw ()
{
  this->getWeaponManager()->getFixedTarget()->debugDraw(10);

  /* draw gun body */
  glMatrixMode(GL_MODELVIEW);
  glPushMatrix();
  glTranslatef (this->getAbsCoor ().x,
                this->getAbsCoor ().y,
                this->getAbsCoor ().z);
  Vector tmpRot = this->getAbsDir().getSpacialAxis();
  glRotatef (this->getAbsDir().getSpacialAxisAngle(), tmpRot.x, tmpRot.y, tmpRot.z );

  this->model->draw();
  glPopMatrix();
}

