/*
   orxonox - the future of 3D-vertical-scrollers

   Copyright (C) 2004 orx

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   ### File Specific:
   main-programmer: Benjamin Grauer
   co-programmer: ...
*/

#define DEBUG_SPECIAL_MODULE DEBUG_MODULE_GUI

#include "glgui_widget.h"

#include "debug.h"

using namespace std;

/**
 * standard constructor
*/
GLGuiWidget::GLGuiWidget ( ) : Element2D(NULL)
{
  this->init();
}


/**
 * standard deconstructor
 */
GLGuiWidget::~GLGuiWidget()
{

}


/**
 * initializes the GUI-element
 */
void GLGuiWidget::init()
{
  this->setClassID(CL_GLGUI_WIDGET, "GLGuiWidget");

  this->focusable = true;
  this->clickable = true;
  this->setVisibility(GLGUI_WIDGET_DEFAULT_VISIBLE);
//  this->setParent2D((Element2D*)NULL);

  this->backMat = NULL;
  this->backModel = 0;
  this->frontMat = NULL;
  this->frontModel = 0;

  for (unsigned int i = 0; i < GLGuiSignalCount; i++)
    this->widgetSignals[i] = NULL;
}


bool GLGuiWidget::focusOverWidget(float x, float y)
{
  if (this->getAbsCoor2D().x < x && this->getAbsCoor2D().x+ this->getSizeX2D() > x &&
      this->getAbsCoor2D().y < y && this->getAbsCoor2D().y+ this->getSizeX2D() > y)
    return true;
  else
    return false;
}

/**
 * @brief connects a Signal to the Gui-Elements' Event.
 * @param sinalType the Type of Signal to set. @see GLGuiSignalType
 * @param signal the name of the Signal
 */
void GLGuiWidget::connectSignal(GLGuiSignalType signalType, Signal* signal)
{
  if (signal == NULL || signalType >= GLGuiSignalCount)
    return;

  if (this->widgetSignals[signalType] != NULL)
    PRINTF(2)("Already connected a Signal to %s (%s) type %s... overwriting\n");

  this->widgetSignals[signalType] = signal;
}

/**
 * @brief removes a Signal from a Gui-ELements' Event
 * @param signalType the type of Signal to remove.
 */
void GLGuiWidget::disconnectSignal(GLGuiSignalType signalType)
{
  if (signalType > GLGuiSignalCount)
    return;

  this->widgetSignals[signalType] = NULL;
}


void GLGuiWidget::show()
{
  this->setVisibility(true);
}
