/*!
 * @file glgui_mainwidget.h
 * @brief Definition of the glGui singleton Class
 */

#ifndef _GLGUI_MAINWIDGET_H
#define _GLGUI_MAINWIDGET_H

#include "glgui_widget.h"

// FORWARD DECLARATION

//! A default singleton class.
class GLGuiMainWidget : public GLGuiWidget {

 public:
  virtual ~GLGuiMainWidget(void);
  /** @returns a Pointer to the only object of this Class */
  inline static GLGuiMainWidget* getInstance(void) { if (!GLGuiMainWidget::singletonRef) GLGuiMainWidget::singletonRef = new GLGuiMainWidget();  return GLGuiMainWidget::singletonRef; };

  virtual void update() {};
  virtual void draw() const {};

 private:
  GLGuiMainWidget(void);
  static GLGuiMainWidget*       singletonRef;
};

#endif /* _GLGUI_MAINWIDGET_H */
