/*!
  \file material.h
  \brief Contains the Material Class that handles Material for 3D-Objects.
  @todo free SDL-surface when deleting Material.
  @todo delete imgNameWithPath after use creation.
*/

#ifndef _MATERIAL_H
#define _MATERIAL_H
#include "base_object.h"

#if HAVE_CONFIG_H
#include <config.h>
#endif /* HAVE_CONFIG_H */

#ifndef NULL
#define NULL 0            //!< a pointer to NULL
#endif

// FORWARD DECLARATIONS //
class Texture;

//! Class to handle Materials.
class Material : public BaseObject
{
 public:
  Material (const char* mtlName = NULL);
  virtual ~Material ();

  bool select () const;

  void setIllum (int illum);
  void setIllum (char* illum);
  void setDiffuse (float r, float g, float b);
  void setDiffuse (char* rgb);
  void setAmbient (float r, float g, float b);
  void setAmbient (char* rgb);
  void setSpecular (float r, float g, float b);
  void setSpecular (char* rgb);
  void setShininess (float shini);
  void setShininess (char* shini);
  void setTransparency (float trans);
  void setTransparency (char* trans);

 // MAPPING //
  void setDiffuseMap(const char* dMap);
  void setAmbientMap(const char* aMap);
  void setSpecularMap(const char* sMap);
  void setBump(const char* bump);

  static void addTexturePath(const char* pathName);

 private:
  int         illumModel;       //!< The IlluminationModel is either flat or smooth.
  float       diffuse [4];      //!< The diffuse color of the Material.
  float       ambient [4];      //!< The ambient color of the Material.
  float       specular [4];     //!< The specular color of the Material.
  float       shininess;        //!< The shininess of the Material.
  float       transparency;     //!< The transperency of the Material.
  public:
  Texture*    diffuseTexture;   //!< The diffuse texture of the Material.
  Texture*    ambientTexture;   //!< The ambient texture of the Material.
  Texture*    specularTexture;  //!< The specular texture of the Material.
};
#endif
