/*
   orxonox - the future of 3D-vertical-scrollers

   Copyright (C) 2004 orx

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   ### File Specific:
   main-programmer: Benjamin Grauer
   co-programmer: ...
*/

#define DEBUG_SPECIAL_MODULE DEBUG_MODULE_GRAPHICS

#include "render_2d.h"

#include "graphics_engine.h"
#include "class_list.h"
#include "list.h"
#include "element_2d.h"

#include <math.h>

using namespace std;

/**
 * standard constructor
 */
Render2D::Render2D ()
{
   this->setClassID(CL_RENDER_2D, "Render2D");
   this->setName("Render2D");
}

/**
 *  the singleton reference to this class
 */
Render2D* Render2D::singletonRef = NULL;

/**
 * standard deconstructor
 */
Render2D::~Render2D ()
{
  delete NullElement2D::getInstance();

  Render2D::singletonRef = NULL;
}

/**
 * ticks all the 2d-elements
 * @param dt the timestep since last dt
 */
void Render2D::tick(float dt)
{
  NullElement2D::getInstance()->tick2D(dt);
}

/**
 * renders all the Elements of the Render2D-engine's layer
 * @param layer the Layer to draw (if E2D_LAYER_ALL then all layers will be drawn)
 */
void Render2D::draw(E2D_LAYER layer) const
{
  GraphicsEngine::enter2DMode();
  NullElement2D::getInstance()->draw2D(E2D_LAYER_ALL);
  GraphicsEngine::leave2DMode();
}


