/*
   orxonox - the future of 3D-vertical-scrollers

   Copyright (C) 2004 orx

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   ### File Specific:
   main-programmer: Benjamin Grauer
   co-programmer: ...
*/

#define DEBUG_SPECIAL_MODULE DEBUG_MODULE_GUI

#include "glgui_button.h"

#include "text.h"

using namespace std;

/**
 * standard constructor
*/
GLGuiButton::GLGuiButton ()
{
  this->init();

}


/**
 * standard deconstructor
*/
GLGuiButton::~GLGuiButton()
{
  /* this does not have to be done, since the Label is a child,
   * and will be deleted by Element2D's deletion Process
   * delete this->label;
  */
}

/**
 * initializes the GUI-element
 */
void GLGuiButton::init()
{
  this->setClassID(CL_GLGUI_BUTTON, "GLGuiButton");

  this->label = new Text();
  this->label->setParent2D(this);
  this->label->setLayer(E2D_LAYER_EXTERN);
}

void GLGuiButton::setLabel(const char* label)
{
  this->label->setText(label);
}


/**
 * draws the GLGuiButton
 */
void GLGuiButton::draw()
{

}
