/*!
 * @file render_2d.h
 * @brief Definition of the 2D-rendering engine singleton Class
 * @todo implement Layer-rendering
*/

#ifndef _RENDER_2D_H
#define _RENDER_2D_H

#include "base_object.h"
#include "element_2d.h"
// FORWARD DEFINITION
template <class T> class tList;

//! A default singleton class.
class Render2D : public BaseObject {
  friend class Element2D;

  public:
    virtual ~Render2D();
    /** @returns a Pointer to the only object of this Class */
    inline static Render2D* getInstance() { if (!singletonRef) singletonRef = new Render2D();  return singletonRef; };

    void tick(float dt);
    void draw(unsigned int layer) const;


  private:
    void registerElement2D(Element2D* element2D);
    void unregisterElement2D(Element2D* element2D);
    void moveToLayer(Element2D* element2D, E2D_LAYER to);


    Render2D();
    static Render2D*              singletonRef;                    //!< Reference to this class.

//  tList<Element2D>*             element2DList;                   //!< List of all valid 2D-elements.
    tList<Element2D>*             element2DList[E2D_LAYER_COUNT];  //!< List of all valid 2D-elements in the different Layers.
};

#endif /* _RENDER_2D_H */
