/*
   orxonox - the future of 3D-vertical-scrollers

   Copyright (C) 2004 orx

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   ### File Specific:
   main-programmer: Benjamin Grauer
   co-programmer: ...
*/

#define DEBUG_SPECIAL_MODULE DEBUG_MODULE_GUI

#include "glgui_frame.h"

#include "debug.h"

using namespace std;

/**
 * standard constructor
*/
GLGuiFrame::GLGuiFrame ()
{
  this->init();

}


/**
 * standard deconstructor
*/
GLGuiFrame::~GLGuiFrame()
{

}

/**
 * initializes the GUI-element
 */
void GLGuiFrame::init()
{
  this->setClassID(CL_GLGUI_FRAME, "GLGuiFrame");
  this->child = NULL;
}

void GLGuiFrame::pack(GLGuiWidget* widget)
{
  if (widget == NULL)
    return;

  if (this->child == NULL)
    this->child = widget;
  else
  {
    PRINTF(2)("Frame %s is already filled, not filling with %s\n", this->getName(), widget->getName());
  }
}

void GLGuiFrame::unpack(GLGuiWidget* widget)
{
  if (widget == NULL || widget == this->child)
    this->child = NULL;
}

void GLGuiFrame::showAll()
{
  if (this->child != NULL)
  {
    if (this->child->isA(CL_GLGUI_CONTAINER))
      static_cast<GLGuiContainer*>(this->child)->showAll();
    else
      this->child->show();
  }
  this->show();
}

void GLGuiFrame::hideAll()
{
  if (this->child != NULL)
  {
    if (this->child->isA(CL_GLGUI_CONTAINER))
      static_cast<GLGuiContainer*>(this->child)->hideAll();
    else
      this->child->hide();
  }
  this->hide();
}


/**
 * draws the GLGuiFrame
 */
void GLGuiFrame::draw()
{

}
